/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.netty;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.transport.amqp.client.util.PropertyUtil;
import org.apache.activemq.transport.netty.NettyTcpTransport;
import org.apache.activemq.transport.netty.NettyTransport;
import org.apache.activemq.transport.netty.NettyTransportOptions;
import org.apache.activemq.transport.netty.NettyTransportSslOptions;
import org.apache.activemq.transport.netty.NettyWSTransport;

public final class NettyTransportFactory {
    private NettyTransportFactory() {
    }

    public static NettyTransport createTransport(URI remoteURI) throws Exception {
        Map<String, String> map = PropertyUtil.parseQuery(remoteURI.getQuery());
        Map<String, String> transportURIOptions = PropertyUtil.filterProperties(map, "transport.");
        NettyTransportOptions transportOptions = null;
        transportOptions = !(remoteURI = PropertyUtil.replaceQuery(remoteURI, map)).getScheme().equalsIgnoreCase("ssl") && !remoteURI.getScheme().equalsIgnoreCase("wss") ? NettyTransportOptions.INSTANCE.clone() : NettyTransportSslOptions.INSTANCE.clone();
        Map<String, String> unused = PropertyUtil.setProperties((Object)transportOptions, transportURIOptions);
        if (!unused.isEmpty()) {
            String msg = " Not all transport options could be set on the TCP based Transport. Check the options are spelled correctly. Unused parameters=[" + unused + "]. This provider instance cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        NettyTcpTransport result = null;
        String scheme = remoteURI.getScheme().toLowerCase();
        if (scheme.startsWith("tcp") || scheme.startsWith("ssl")) {
            result = new NettyTcpTransport(remoteURI, transportOptions);
        } else if (scheme.startsWith("ws") || scheme.startsWith("wss")) {
            if (scheme.contains("+")) {
                transportOptions.setWsSubProtocol(scheme.substring(scheme.indexOf("+") + 1));
            }
            result = new NettyWSTransport(remoteURI, transportOptions);
        } else {
            throw new IllegalArgumentException("Invalid URI Scheme: " + remoteURI.getScheme());
        }
        return result;
    }
}

