/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.extensions.ExtensionFunction;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.extensions.PerMessageDeflateFunction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PerMessageDeflateHandshake
implements ExtensionHandshake {
    private static final String PERMESSAGE_DEFLATE = "permessage-deflate";
    private static final String SERVER_NO_CONTEXT_TAKEOVER = "server_no_context_takeover";
    private static final String CLIENT_NO_CONTEXT_TAKEOVER = "client_no_context_takeover";
    private static final String SERVER_MAX_WINDOW_BITS = "server_max_window_bits";
    private static final String CLIENT_MAX_WINDOW_BITS = "client_max_window_bits";
    private final Set<String> incompatibleExtensions = new HashSet<String>();
    private boolean compressContextTakeover;
    private boolean decompressContextTakeover;
    private final boolean client;
    private final int deflaterLevel;
    public static final int DEFAULT_DEFLATER = -1;

    public PerMessageDeflateHandshake() {
        this(false);
    }

    public PerMessageDeflateHandshake(boolean client) {
        this(client, -1);
    }

    public PerMessageDeflateHandshake(boolean client, int deflaterLevel) {
        this(client, deflaterLevel, true, true);
    }

    public PerMessageDeflateHandshake(boolean client, boolean compressContextTakeover, boolean decompressContextTakeover) {
        this(client, -1, compressContextTakeover, decompressContextTakeover);
    }

    public PerMessageDeflateHandshake(boolean client, int deflaterLevel, boolean compressContextTakeover, boolean decompressContextTakeover) {
        this.client = client;
        this.deflaterLevel = deflaterLevel;
        this.incompatibleExtensions.add(PERMESSAGE_DEFLATE);
        this.compressContextTakeover = compressContextTakeover;
        this.decompressContextTakeover = decompressContextTakeover;
    }

    @Override
    public String getName() {
        return PERMESSAGE_DEFLATE;
    }

    @Override
    public WebSocketExtension accept(WebSocketExtension extension) {
        if (extension == null || !extension.getName().equals(this.getName())) {
            return null;
        }
        WebSocketExtension negotiated = new WebSocketExtension(extension.getName());
        if (extension.getParameters() == null || extension.getParameters().size() == 0) {
            return negotiated;
        }
        for (WebSocketExtension.Parameter parameter : extension.getParameters()) {
            if (parameter.getName().equals(SERVER_MAX_WINDOW_BITS) || parameter.getName().equals(CLIENT_MAX_WINDOW_BITS)) continue;
            if (parameter.getName().equals(SERVER_NO_CONTEXT_TAKEOVER)) {
                negotiated.getParameters().add(parameter);
                if (this.client) {
                    this.decompressContextTakeover = false;
                    continue;
                }
                this.compressContextTakeover = false;
                continue;
            }
            if (parameter.getName().equals(CLIENT_NO_CONTEXT_TAKEOVER)) {
                negotiated.getParameters().add(parameter);
                if (this.client) {
                    this.compressContextTakeover = false;
                    continue;
                }
                this.decompressContextTakeover = false;
                continue;
            }
            WebSocketLogger.EXTENSION_LOGGER.incorrectExtensionParameter(parameter);
            return null;
        }
        WebSocketLogger.EXTENSION_LOGGER.debugf("Negotiated extension %s for handshake %s", (Object)negotiated, (Object)extension);
        return negotiated;
    }

    @Override
    public boolean isIncompatible(List<ExtensionHandshake> extensions) {
        for (ExtensionHandshake extension : extensions) {
            if (!this.incompatibleExtensions.contains(extension.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExtensionFunction create() {
        return new PerMessageDeflateFunction(this.deflaterLevel, this.compressContextTakeover, this.decompressContextTakeover);
    }
}

