/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schema.serverLocator;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.uri.schema.connector.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.ConnectionOptions;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class TCPServerLocatorSchema
extends AbstractServerLocatorSchema {
    @Override
    public String getSchemaName() {
        return "tcp";
    }

    @Override
    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        List<TransportConfiguration> configurations = TCPTransportConfigurationSchema.getTransportConfigurations(uri, query, TransportConstants.ALLOWABLE_CONNECTOR_KEYS, name, NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        BeanSupport.stripPasswords(query);
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        if (options.isHa()) {
            return BeanSupport.setData(uri, ActiveMQClient.createServerLocatorWithHA(tcs), query);
        }
        return BeanSupport.setData(uri, ActiveMQClient.createServerLocatorWithoutHA(tcs), query);
    }

    @Override
    protected URI internalNewURI(ServerLocator bean) throws Exception {
        String query = BeanSupport.getData(null, bean);
        TransportConfiguration[] staticConnectors = bean.getStaticTransportConfigurations();
        return TCPServerLocatorSchema.getURI(query, staticConnectors);
    }

    public static URI getURI(String query, TransportConfiguration[] staticConnectors) throws Exception {
        if (staticConnectors == null || staticConnectors.length < 1) {
            throw new Exception();
        }
        StringBuilder fragment = new StringBuilder();
        for (int i = 1; i < staticConnectors.length; ++i) {
            TransportConfiguration connector = staticConnectors[i];
            Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(connector.getCombinedParams());
            URI extraUri = new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, null), null);
            if (i > 1) {
                fragment.append(",");
            }
            fragment.append(extraUri.toASCIIString());
        }
        Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(staticConnectors[0].getCombinedParams());
        return new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, query), fragment.toString());
    }

    private static Map<String, Object> escapeIPv6Host(Map<String, Object> params) {
        String newHost;
        String host = (String)params.get("host");
        if (host != (newHost = IPV6Util.encloseHost(host))) {
            params.put("host", "[" + host + "]");
        }
        return params;
    }

    private static int getPort(Map<String, Object> params) {
        Object port = params.get("port");
        if (port instanceof String) {
            return Integer.parseInt((String)port);
        }
        return port != null ? (Integer)port : 61616;
    }

    private static String getHost(Map<String, Object> params) {
        return params.get("host") != null ? (String)params.get("host") : "localhost";
    }

    private static String createQuery(Map<String, Object> params, String query) throws Exception {
        boolean empty;
        StringBuilder cb;
        if (query == null) {
            cb = new StringBuilder();
            empty = true;
        } else {
            cb = new StringBuilder(query);
            empty = false;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!empty) {
                cb.append("&");
            } else {
                empty = false;
            }
            cb.append(BeanSupport.encodeURI(entry.getKey()));
            cb.append("=");
            cb.append(BeanSupport.encodeURI(entry.getValue().toString()));
        }
        return cb.toString();
    }
}

