/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.OpenType;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jmx.logging.JmxLogger;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;

public class JmxLogger_$logger
extends DelegatingBasicLogger
implements JmxLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JmxLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public JmxLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void cannotUnregisterObject() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotUnregisterObject$str(), new Object[0]);
    }

    protected String cannotUnregisterObject$str() {
        return "WFLYJMX0004: No ObjectName available to unregister";
    }

    @Override
    public final void unregistrationFailure(Throwable cause, ObjectName name) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.unregistrationFailure$str(), (Object)name);
    }

    protected String unregistrationFailure$str() {
        return "WFLYJMX0005: Failed to unregister [%s]";
    }

    @Override
    public final void jmxConnectorNotSupported() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.jmxConnectorNotSupported$str(), new Object[0]);
    }

    protected String jmxConnectorNotSupported$str() {
        return "WFLYJMX0006: <jmx-connector/> is no longer supporting. <remoting-connector/> should be used instead to allow remote connections via JBoss Remoting.";
    }

    protected String compositeEntryTypeName$str() {
        return "entry";
    }

    @Override
    public final String compositeEntryTypeName() {
        return String.format(this.getLoggingLocale(), this.compositeEntryTypeName$str(), new Object[0]);
    }

    protected String compositeEntryTypeDescription$str() {
        return "An entry";
    }

    @Override
    public final String compositeEntryTypeDescription() {
        return String.format(this.getLoggingLocale(), this.compositeEntryTypeDescription$str(), new Object[0]);
    }

    protected String compositeEntryKeyDescription$str() {
        return "The key";
    }

    @Override
    public final String compositeEntryKeyDescription() {
        return String.format(this.getLoggingLocale(), this.compositeEntryKeyDescription$str(), new Object[0]);
    }

    protected String compositeEntryValueDescription$str() {
        return "The value";
    }

    @Override
    public final String compositeEntryValueDescription() {
        return String.format(this.getLoggingLocale(), this.compositeEntryValueDescription$str(), new Object[0]);
    }

    protected String compositeMapName$str() {
        return "A map";
    }

    @Override
    public final String compositeMapName() {
        return String.format(this.getLoggingLocale(), this.compositeMapName$str(), new Object[0]);
    }

    protected String compositeMapDescription$str() {
        return "The map is indexed by 'key'";
    }

    @Override
    public final String compositeMapDescription() {
        return String.format(this.getLoggingLocale(), this.compositeMapDescription$str(), new Object[0]);
    }

    protected String complexCompositeEntryTypeName$str() {
        return "Complex type";
    }

    @Override
    public final String complexCompositeEntryTypeName() {
        return String.format(this.getLoggingLocale(), this.complexCompositeEntryTypeName$str(), new Object[0]);
    }

    protected String complexCompositeEntryTypeDescription$str() {
        return "A complex type";
    }

    @Override
    public final String complexCompositeEntryTypeDescription() {
        return String.format(this.getLoggingLocale(), this.complexCompositeEntryTypeDescription$str(), new Object[0]);
    }

    protected String descriptorMBeanExpressionSupportFalse$str() {
        return "This mbean does not support expressions for attributes or operation parameters, even when supported by the underlying model. Instead the resolved attribute is returned, and the real typed value must be used when writing attributes/invoking operations.";
    }

    @Override
    public final String descriptorMBeanExpressionSupportFalse() {
        return String.format(this.getLoggingLocale(), this.descriptorMBeanExpressionSupportFalse$str(), new Object[0]);
    }

    protected String descriptorMBeanExpressionSupportTrue$str() {
        return "This mbean supports raw expressions for attributes and operation parameters where supported by the underlying model. If no expression is used, the string representation is converted into the real attribute value.";
    }

    @Override
    public final String descriptorMBeanExpressionSupportTrue() {
        return String.format(this.getLoggingLocale(), this.descriptorMBeanExpressionSupportTrue$str(), new Object[0]);
    }

    protected String descriptorAlternateMBeanExpressions$str() {
        return "To be able to set and read expressions go to %s";
    }

    @Override
    public final String descriptorAlternateMBeanExpressions(ObjectName objectName) {
        return String.format(this.getLoggingLocale(), this.descriptorAlternateMBeanExpressions$str(), objectName);
    }

    protected String descriptorAlternateMBeanLegacy$str() {
        return "To read resolved values and to write typed attributes and use typed operation parameters go to %s";
    }

    @Override
    public final String descriptorAlternateMBeanLegacy(ObjectName objectName) {
        return String.format(this.getLoggingLocale(), this.descriptorAlternateMBeanLegacy$str(), objectName);
    }

    protected String descriptorAttributeExpressionsAllowedTrue$str() {
        return "This attribute supports expressions";
    }

    @Override
    public final String descriptorAttributeExpressionsAllowedTrue() {
        return String.format(this.getLoggingLocale(), this.descriptorAttributeExpressionsAllowedTrue$str(), new Object[0]);
    }

    protected String descriptorAttributeExpressionsAllowedFalse$str() {
        return "This attribute does not support expressions";
    }

    @Override
    public final String descriptorAttributeExpressionsAllowedFalse() {
        return String.format(this.getLoggingLocale(), this.descriptorAttributeExpressionsAllowedFalse$str(), new Object[0]);
    }

    protected String propertyCompositeType$str() {
        return "A composite type representing a property";
    }

    @Override
    public final String propertyCompositeType() {
        return String.format(this.getLoggingLocale(), this.propertyCompositeType$str(), new Object[0]);
    }

    protected String propertyName$str() {
        return "The property name";
    }

    @Override
    public final String propertyName() {
        return String.format(this.getLoggingLocale(), this.propertyName$str(), new Object[0]);
    }

    protected String propertyValue$str() {
        return "The property value";
    }

    @Override
    public final String propertyValue() {
        return String.format(this.getLoggingLocale(), this.propertyValue$str(), new Object[0]);
    }

    protected String attributeNotFound$str() {
        return "WFLYJMX0007: Could not find any attribute matching: %s";
    }

    @Override
    public final AttributeNotFoundException attributeNotFound(String name) {
        AttributeNotFoundException result = new AttributeNotFoundException(String.format(this.getLoggingLocale(), this.attributeNotFound$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String attributeNotWritable$str() {
        return "WFLYJMX0008: Attribute %s is not writable";
    }

    @Override
    public final AttributeNotFoundException attributeNotWritable(Attribute attribute) {
        AttributeNotFoundException result = new AttributeNotFoundException(String.format(this.getLoggingLocale(), this.attributeNotWritable$str(), attribute));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateObjectName$str() {
        return "WFLYJMX0009: Could not create ObjectName for address %s from string %s";
    }

    @Override
    public final RuntimeException cannotCreateObjectName(Throwable cause, PathAddress address, String s) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotCreateObjectName$str(), address, s), cause);
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotSetAttribute$str() {
        return "WFLYJMX0010: Could not set %s";
    }

    @Override
    public final ReflectionException cannotSetAttribute(Exception cause, String name) {
        ReflectionException result = new ReflectionException(cause, String.format(this.getLoggingLocale(), this.cannotSetAttribute$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentLengths$str() {
        return "WFLYJMX0012: %s and %s have different lengths";
    }

    @Override
    public final IllegalArgumentException differentLengths(String name1, String name2) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.differentLengths$str(), name1, name2));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidAttributeType$str() {
        return "WFLYJMX0013: Bad type for '%s'";
    }

    @Override
    public final InvalidAttributeValueException invalidAttributeType(Throwable cause, String name) {
        InvalidAttributeValueException result = new InvalidAttributeValueException(String.format(this.getLoggingLocale(), this.invalidAttributeType$str(), name));
        result.initCause(cause);
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidKey$str() {
        return "WFLYJMX0014: Invalid key %s for %s";
    }

    @Override
    public final IllegalArgumentException invalidKey(List<?> keys, Map.Entry<?, Object> entry) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidKey$str(), keys, entry));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidObjectName2$str() {
        return "WFLYJMX0015: Invalid ObjectName: %s; %s";
    }

    @Override
    public final Error invalidObjectName(String name, String message) {
        Error result = new Error(String.format(this.getLoggingLocale(), this.invalidObjectName2$str(), name, message));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidObjectName3$str() {
        return "WFLYJMX0015: Invalid ObjectName: %s,%s; %s";
    }

    @Override
    public final Error invalidObjectName(String domain, Hashtable<String, String> table, String message) {
        Error result = new Error(String.format(this.getLoggingLocale(), this.invalidObjectName3$str(), domain, table, message));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidObjectName4$str() {
        return "WFLYJMX0015: Invalid ObjectName: %s,%s,%s; %s";
    }

    @Override
    public final Error invalidObjectName(String domain, String key, String value, String message) {
        Error result = new Error(String.format(this.getLoggingLocale(), this.invalidObjectName4$str(), domain, key, value, message));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mbeanNotFound$str() {
        return "WFLYJMX0017: No MBean found with name %s";
    }

    @Override
    public final InstanceNotFoundException mbeanNotFound(ObjectName name) {
        InstanceNotFoundException result = new InstanceNotFoundException(String.format(this.getLoggingLocale(), this.mbeanNotFound$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String mbeanRegistrationFailed$str() {
        return "WFLYJMX0018: Failed to register mbean [%s]";
    }

    @Override
    public final StartException mbeanRegistrationFailed(Throwable cause, String name) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.mbeanRegistrationFailed$str(), name), cause);
        JmxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noOperationCalled1$str() {
        return "WFLYJMX0019: No operation called '%s'";
    }

    @Override
    public final InstanceNotFoundException noOperationCalled(String operation) {
        InstanceNotFoundException result = new InstanceNotFoundException(String.format(this.getLoggingLocale(), this.noOperationCalled1$str(), operation));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noOperationCalled2$str() {
        return "WFLYJMX0020: No operation called '%s' at %s";
    }

    @Override
    public final MBeanException noOperationCalled(Exception cause, String operation, PathAddress address) {
        MBeanException result = new MBeanException(cause, String.format(this.getLoggingLocale(), this.noOperationCalled2$str(), operation, address));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String registrationNotFound$str() {
        return "WFLYJMX0022: No registration found for path address %s";
    }

    @Override
    public final InstanceNotFoundException registrationNotFound(PathAddress address) {
        InstanceNotFoundException result = new InstanceNotFoundException(String.format(this.getLoggingLocale(), this.registrationNotFound$str(), address));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownType$str() {
        return "WFLYJMX0024: Unknown type %s";
    }

    @Override
    public final RuntimeException unknownType(ModelType type) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownType$str(), type));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownValue$str() {
        return "WFLYJMX0025: Unknown value %s";
    }

    @Override
    public final IllegalArgumentException unknownValue(Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownValue$str(), value));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String wildcardNameParameterRequired$str() {
        return "WFLYJMX0026: Need the name parameter for wildcard add";
    }

    @Override
    public final IllegalStateException wildcardNameParameterRequired() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.wildcardNameParameterRequired$str(), new Object[0]));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownDomain$str() {
        return "WFLYJMX0029: Unknown domain: %s";
    }

    @Override
    public final IllegalArgumentException unknownDomain(String domain) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownDomain$str(), domain));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String expressionCannotBeConvertedIntoTargeteType$str() {
        return "WFLYJMX0030: Expression can not be converted into target type %s";
    }

    @Override
    public final IllegalArgumentException expressionCannotBeConvertedIntoTargeteType(OpenType<?> type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.expressionCannotBeConvertedIntoTargeteType$str(), type));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownChild$str() {
        return "WFLYJMX0031: Unknown child %s";
    }

    @Override
    public final IllegalArgumentException unknownChild(String child) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownChild$str(), child));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String objectNameCantBeNull$str() {
        return "WFLYJMX0032: ObjectName cannot be null";
    }

    @Override
    public final IllegalArgumentException objectNameCantBeNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.objectNameCantBeNull$str(), new Object[0]));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noHandlerCalled$str() {
        return "WFLYJMX0036: There is no handler called '%s'";
    }

    @Override
    public final IllegalStateException noHandlerCalled(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noHandlerCalled$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unauthorized$str() {
        return "WFLYJMX0037: Unauthorized access";
    }

    @Override
    public final JMRuntimeException unauthorized() {
        JMRuntimeException result = new JMRuntimeException(String.format(this.getLoggingLocale(), this.unauthorized$str(), new Object[0]));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAuthorizedToWriteAttribute$str() {
        return "WFLYJMX0038: Not authorized to write attribute: '%s'";
    }

    @Override
    public final JMRuntimeException notAuthorizedToWriteAttribute(String attributeName) {
        JMRuntimeException result = new JMRuntimeException(String.format(this.getLoggingLocale(), this.notAuthorizedToWriteAttribute$str(), attributeName));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAuthorizedToReadAttribute$str() {
        return "WFLYJMX0039: Not authorized to read attribute: '%s'";
    }

    @Override
    public final JMRuntimeException notAuthorizedToReadAttribute(String attributeName) {
        JMRuntimeException result = new JMRuntimeException(String.format(this.getLoggingLocale(), this.notAuthorizedToReadAttribute$str(), attributeName));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAuthorizedToExecuteOperation$str() {
        return "WFLYJMX0040: Not authorized to invoke operation: '%s'";
    }

    @Override
    public final JMRuntimeException notAuthorizedToExecuteOperation(String operationName) {
        JMRuntimeException result = new JMRuntimeException(String.format(this.getLoggingLocale(), this.notAuthorizedToExecuteOperation$str(), operationName));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateMBeansInReservedDomain$str() {
        return "WFLYJMX0041: You can't create mbeans under the reserved domain '%s'";
    }

    @Override
    public final NotCompliantMBeanException cannotCreateMBeansInReservedDomain(String domain) {
        NotCompliantMBeanException result = new NotCompliantMBeanException(String.format(this.getLoggingLocale(), this.cannotCreateMBeansInReservedDomain$str(), domain));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String dontKnowHowToDeserialize$str() {
        return "WFLYJMX0042: Don't know how to deserialize";
    }

    @Override
    public final OperationsException dontKnowHowToDeserialize() {
        OperationsException result = new OperationsException(String.format(this.getLoggingLocale(), this.dontKnowHowToDeserialize$str(), new Object[0]));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedMethod$str() {
        return "WFLYJMX0043: %s is not supported";
    }

    @Override
    public final UnsupportedOperationException unsupportedMethod(String name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedMethod$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRegisterMBeansUnderReservedDomain$str() {
        return "WFLYJMX0044: You can't register mbeans under the reserved domain '%s'";
    }

    @Override
    public final String cannotRegisterMBeansUnderReservedDomain(String domain) {
        return String.format(this.getLoggingLocale(), this.cannotRegisterMBeansUnderReservedDomain$str(), domain);
    }

    protected String cannotUnregisterMBeansUnderReservedDomain$str() {
        return "WFLYJMX0045: You can't unregister mbeans under the reserved domain '%s'";
    }

    @Override
    public final String cannotUnregisterMBeansUnderReservedDomain(String domain) {
        return String.format(this.getLoggingLocale(), this.cannotUnregisterMBeansUnderReservedDomain$str(), domain);
    }

    protected String badDomainInCalculatedObjectNameException$str() {
        return "WFLYJMX0046: The ObjectName coming from MBeanRegistration.preRegister() '%s' is in a reserved JMX domain";
    }

    @Override
    public final IllegalArgumentException badDomainInCalculatedObjectNameException(ObjectName name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.badDomainInCalculatedObjectNameException$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void errorUnregisteringMBeanWithBadCalculatedName(Exception e, ObjectName name) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorUnregisteringMBeanWithBadCalculatedName$str(), (Object)name);
    }

    protected String errorUnregisteringMBeanWithBadCalculatedName$str() {
        return "WFLYJMX0047: An error happened unregistering the '%s' MBean registered in a reserved JMX domain";
    }

    protected String addNotificationListerWithObjectNameNotSupported$str() {
        return "WFLYJMX0048: Add notification listener using ObjectName %s is not supported";
    }

    @Override
    public final UnsupportedOperationException addNotificationListerWithObjectNameNotSupported(ObjectName listener) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.addNotificationListerWithObjectNameNotSupported$str(), listener));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removeNotificationListerWithObjectNameNotSupported$str() {
        return "WFLYJMX0049: Remove notification listener using ObjectName %s is not supported";
    }

    @Override
    public final UnsupportedOperationException removeNotificationListerWithObjectNameNotSupported(ObjectName listener) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.removeNotificationListerWithObjectNameNotSupported$str(), listener));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String addNotificationListenerNotAllowed$str() {
        return "WFLYJMX0050: Add notification listener using ObjectName %s is not supported";
    }

    @Override
    public final UnsupportedOperationException addNotificationListenerNotAllowed(ObjectName name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.addNotificationListenerNotAllowed$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String removeNotificationListenerNotAllowed$str() {
        return "WFLYJMX0051: Remove notification listener using ObjectName %s is not supported";
    }

    @Override
    public final UnsupportedOperationException removeNotificationListenerNotAllowed(ObjectName name) {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.removeNotificationListenerNotAllowed$str(), name));
        JmxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

