/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.injection.deployment;

import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.wildfly.extension.messaging.activemq.injection._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.injection.deployment.JMSInfo;

public abstract class AbstractJMSContext
implements Serializable {
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Map<String, JMSContext> contexts = new ConcurrentHashMap<String, JMSContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JMSContext getContext(String injectionPointId, JMSInfo info, ConnectionFactory connectionFactory) {
        JMSContext context = this.contexts.get(injectionPointId);
        if (context == null) {
            this.lock.lock();
            try {
                context = this.contexts.get(injectionPointId);
                if (context == null) {
                    context = this.createContext(info, connectionFactory);
                    this.contexts.put(injectionPointId, context);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return context;
    }

    private JMSContext createContext(JMSInfo info, ConnectionFactory connectionFactory) {
        JMSContext context;
        MessagingLogger.ROOT_LOGGER.debugf("Create JMSContext from %s - %s", info, connectionFactory);
        int sessionMode = info.getSessionMode();
        String userName = info.getUserName();
        if (userName == null) {
            context = connectionFactory.createContext(sessionMode);
        } else {
            String password = info.getPassword();
            context = connectionFactory.createContext(userName, password, sessionMode);
        }
        return context;
    }

    void cleanUp() {
        MessagingLogger.ROOT_LOGGER.debugf("Clean up JMSContext created from %s", this);
        for (JMSContext jmsContext : this.contexts.values()) {
            jmsContext.close();
        }
        this.contexts.clear();
    }
}

