/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.clustering.controller.ChildResourceDefinition;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleResourceRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ChannelResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkChannelFactoryServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.ForkProtocolRuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jgroups.JChannel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ForkChannelFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capture.FunctionExecutorRegistry;
import org.wildfly.subsystem.service.capture.ServiceValueExecutorRegistry;

public class ForkResourceDefinition
extends ChildResourceDefinition<ManagementResourceRegistration>
implements ResourceServiceConfigurator {
    public static final PathElement WILDCARD_PATH = ForkResourceDefinition.pathElement("*");
    private final ResourceServiceConfigurator configurator = new ForkChannelFactoryServiceConfigurator(ChannelResourceDefinition.CHANNEL_FACTORY_CAPABILITY, PathAddress::getParent);
    private final ServiceValueExecutorRegistry<JChannel> registry;

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"fork", (String)name);
    }

    ForkResourceDefinition(ServiceValueExecutorRegistry<JChannel> registry) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(WILDCARD_PATH));
        this.registry = registry;
    }

    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = parent.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addCapabilities(List.of(ChannelResourceDefinition.CHANNEL_CAPABILITY, ChannelResourceDefinition.CHANNEL_FACTORY_CAPABILITY));
        ResourceOperationRuntimeHandler handler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        new SimpleResourceRegistrar(descriptor, ResourceServiceHandler.of((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{handler})).register(registration);
        new ProtocolResourceRegistrar(this.configurator, new ForkProtocolRuntimeResourceRegistration((FunctionExecutorRegistry<JChannel>)this.registry)).register(registration);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = address.getLastElement().getValue();
        String channelName = address.getParent().getLastElement().getValue();
        LinkedList<Object> installers = new LinkedList<Object>();
        installers.add(this.configurator.configure(context, model));
        final ServiceDependency channelFactory = ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)channelName).map(ForkChannelFactory.class::cast);
        final ServiceDependency clusterName = ServiceDependency.on(ChannelResourceDefinition.CHANNEL_CLUSTER, (String)channelName);
        ChannelServiceConfiguration configuration = new ChannelServiceConfiguration(){

            @Override
            public boolean isStatisticsEnabled() {
                return false;
            }

            @Override
            public org.wildfly.clustering.jgroups.ChannelFactory getChannelFactory() {
                return (org.wildfly.clustering.jgroups.ChannelFactory)channelFactory.get();
            }

            @Override
            public String getClusterName() {
                return (String)clusterName.get();
            }

            @Override
            public void accept(RequirementServiceBuilder<?> builder) {
                channelFactory.accept(builder);
            }
        };
        installers.add(new ChannelServiceConfigurator(ChannelResourceDefinition.CHANNEL_CAPABILITY, configuration).configure(context, model));
        installers.add(this.registry.capture(ServiceDependency.on(ChannelResourceDefinition.CHANNEL, (String)name)));
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.createChannelBinding(name), ChannelResourceDefinition.CHANNEL_CAPABILITY.getCapabilityServiceName(address)));
        installers.add(new BinderServiceInstaller(JGroupsBindingFactory.createChannelFactoryBinding(name), ChannelResourceDefinition.CHANNEL_FACTORY_CAPABILITY.getCapabilityServiceName(address)));
        return ResourceServiceInstaller.combine(installers);
    }
}

