/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.conf.XmlConfigurator;
import org.jgroups.stack.Protocol;
import org.wildfly.subsystem.service.ServiceInstaller;

public class ProtocolDefaultsServiceInstaller
implements ServiceInstaller {
    private static final String DEFAULTS = "jgroups-defaults.xml";

    private static ProtocolStackConfigurator load(String resource) throws IllegalStateException {
        XmlConfigurator xmlConfigurator;
        block8: {
            URL url = ProtocolDefaultsServiceInstaller.find(resource, JGroupsExtension.class.getClassLoader());
            JGroupsLogger.ROOT_LOGGER.debugf("Loading JGroups protocol defaults from %s", url.toString());
            InputStream input = url.openStream();
            try {
                xmlConfigurator = XmlConfigurator.getInstance((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.parserFailure(url));
                }
            }
            input.close();
        }
        return xmlConfigurator;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = loader.getResource(resource)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(JGroupsLogger.ROOT_LOGGER.notFound(resource));
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        Supplier<ProtocolDefaults> factory = ResourceProtocolDefaults::new;
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(factory).blocking()).provides(ProtocolDefaults.SERVICE_NAME)).build()).install((ServiceTarget)target);
    }

    private static class ResourceProtocolDefaults
    implements ProtocolDefaults {
        private final Map<Class<? extends Protocol>, Map<String, String>> protocols = new IdentityHashMap<Class<? extends Protocol>, Map<String, String>>();

        ResourceProtocolDefaults() {
            this(ProtocolDefaultsServiceInstaller.DEFAULTS);
        }

        ResourceProtocolDefaults(String resource) {
            ProtocolStackConfigurator configurator = ProtocolDefaultsServiceInstaller.load(resource);
            try {
                for (ProtocolConfiguration config : configurator.getProtocolStack()) {
                    String protocolClassName = "org.jgroups.protocols." + config.getProtocolName();
                    Class<Protocol> protocolClass = Protocol.class.getClassLoader().loadClass(protocolClassName).asSubclass(Protocol.class);
                    this.protocols.put(protocolClass, Collections.unmodifiableMap(config.getProperties()));
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public Map<String, String> getProperties(Class<? extends Protocol> protocolClass) {
            return this.protocols.getOrDefault(protocolClass, Map.of());
        }
    }
}

