/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.soteria.original;

import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.security.enterprise.identitystore.openid.Claims;
import jakarta.security.enterprise.identitystore.openid.OpenIdClaims;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;

class JsonClaims
implements OpenIdClaims {
    private final JsonObject claims;

    JsonClaims(JsonObject claims) {
        this.claims = claims;
    }

    public Optional<String> getStringClaim(String name) {
        return Optional.ofNullable(this.claims.getString(name, null));
    }

    public Optional<Instant> getNumericDateClaim(String name) {
        return Optional.ofNullable(this.getNumber(name)).map(n -> Instant.ofEpochSecond(n.longValue()));
    }

    public List<String> getArrayStringClaim(String name) {
        JsonValue value = (JsonValue)this.claims.get((Object)name);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.getValueType() == JsonValue.ValueType.ARRAY) {
            return value.asJsonArray().stream().map(this::getStringValue).collect(Collectors.toList());
        }
        return Collections.singletonList(this.getStringValue(value));
    }

    private String getStringValue(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NUMBER: {
                return ((JsonNumber)value).numberValue().toString();
            }
        }
        throw new IllegalArgumentException("Cannot handle nested JSON value in a claim:" + String.valueOf(value));
    }

    private JsonNumber getNumber(String name) {
        try {
            return this.claims.getJsonNumber(name);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Cannot interpret " + name + " as number", cce);
        }
    }

    public OptionalInt getIntClaim(String name) {
        JsonNumber value = this.getNumber(name);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value.intValue());
    }

    public OptionalLong getLongClaim(String name) {
        JsonNumber value = this.getNumber(name);
        return value == null ? OptionalLong.empty() : OptionalLong.of(value.longValue());
    }

    public OptionalDouble getDoubleClaim(String name) {
        JsonNumber value = this.getNumber(name);
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value.doubleValue());
    }

    public Optional<Claims> getNested(String claimName) {
        return Optional.ofNullable(this.claims.getJsonObject(claimName)).map(JsonClaims::new);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{subject=" + this.getSubject() + ",name=" + String.valueOf(this.getName()) + ", familyName=" + String.valueOf(this.getFamilyName()) + ", givenName=" + String.valueOf(this.getGivenName()) + ", middleName=" + String.valueOf(this.getMiddleName()) + ", nickname=" + String.valueOf(this.getNickname()) + ", preferredUsername=" + String.valueOf(this.getPreferredUsername()) + ", profile=" + String.valueOf(this.getProfile()) + ", picture=" + String.valueOf(this.getPicture()) + ", website=" + String.valueOf(this.getWebsite()) + ", gender=" + String.valueOf(this.getGender()) + ", birthdate=" + String.valueOf(this.getBirthdate()) + ", zoneinfo=" + String.valueOf(this.getZoneinfo()) + ", locale=" + String.valueOf(this.getLocale()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", email=" + String.valueOf(this.getEmail()) + ", emailVerified=" + String.valueOf(this.getEmailVerified()) + ", address=" + String.valueOf(this.getAddress()) + ", phoneNumber=" + String.valueOf(this.getPhoneNumber()) + ", phoneNumberVerified=" + String.valueOf(this.getPhoneNumberVerified()) + "}";
    }
}

