/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleResourceDescriptorConfigurator;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.session.cache.affinity.NarySessionAffinityConfiguration;
import org.wildfly.clustering.web.service.routing.RouteLocatorProvider;
import org.wildfly.clustering.web.service.routing.RoutingProvider;
import org.wildfly.common.function.Functions;
import org.wildfly.extension.clustering.web.AffinityResourceDefinition;
import org.wildfly.extension.clustering.web.routing.infinispan.RankedRouteLocatorProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class RankedAffinityResourceDefinition
extends AffinityResourceDefinition {
    static final PathElement PATH = RankedAffinityResourceDefinition.pathElement("ranked");
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)RouteLocatorProvider.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).addRequirements(new String[]{RoutingProvider.INFINISPAN_SERVICE_DESCRIPTOR.getName()}).build();

    RankedAffinityResourceDefinition() {
        super(PATH, CAPABILITY, (UnaryOperator<ResourceDescriptor>)new SimpleResourceDescriptorConfigurator(Attribute.class));
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        final String delimiter = Attribute.DELIMITER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final int maxRoutes = Attribute.MAX_ROUTES.resolveModelAttribute((ExpressionResolver)context, model).asInt();
        NarySessionAffinityConfiguration configuration = new NarySessionAffinityConfiguration(){

            public int getMaxMembers() {
                return maxRoutes;
            }

            public String getDelimiter() {
                return delimiter;
            }
        };
        return (ResourceServiceInstaller)CapabilityServiceInstaller.builder(CAPABILITY, RankedRouteLocatorProvider::new, (Supplier)Functions.constantSupplier((Object)configuration)).build();
    }

    public static enum Attribute implements org.jboss.as.clustering.controller.Attribute
    {
        DELIMITER("delimiter", ModelType.STRING, new ModelNode(".")),
        MAX_ROUTES("max-routes", ModelType.STRING, new ModelNode(3));

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type, ModelNode defaultValue) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(false)).setDefaultValue(defaultValue)).setRequired(false)).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

