/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.version.Stability;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.extension.core.management.CoreManagementExtension;
import org.wildfly.extension.core.management.deployment.ReportUnstableApiAnnotationsProcessor;
import org.wildfly.extension.core.management.deployment.ScanUnstableApiAnnotationsProcessor;

public class UnstableApiAnnotationResourceDefinition
extends PersistentResourceDefinition {
    public static final Stability STABILITY = Stability.PREVIEW;
    public static final SimpleAttributeDefinition LEVEL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"level", (ModelType)ModelType.STRING, (boolean)true).setValidator((ParameterValidator)EnumValidator.create(UnstableApiAnnotationLevel.class))).setDefaultValue(new ModelNode(UnstableApiAnnotationLevel.LOG.name()))).setRestartAllServices()).build();
    public static final PathElement PATH = PathElement.pathElement((String)"service", (String)"unstable-api-annotations");
    static final ResourceRegistration RESOURCE_REGISTRATION = ResourceRegistration.of((PathElement)PATH, (Stability)STABILITY);
    static final UnstableApiAnnotationResourceDefinition INSTANCE = new UnstableApiAnnotationResourceDefinition();
    private static final List<AttributeDefinition> ATTRIBUTES = Collections.singletonList(LEVEL);

    private UnstableApiAnnotationResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(RESOURCE_REGISTRATION, CoreManagementExtension.getResourceDescriptionResolver("unstable-api-annotations")).setAddHandler((OperationStepHandler)UnstableApiAnnotationResourceAddHandler.INSTANCE).setRemoveHandler((OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    public static enum UnstableApiAnnotationLevel {
        LOG,
        ERROR;

    }

    private static class UnstableApiAnnotationResourceAddHandler
    extends AbstractBoottimeAddStepHandler {
        static final UnstableApiAnnotationResourceAddHandler INSTANCE = new UnstableApiAnnotationResourceAddHandler();

        private UnstableApiAnnotationResourceAddHandler() {
        }

        public void performBoottime(final OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            String levelValue = LEVEL.resolveModelAttribute(context, model).asString();
            final UnstableApiAnnotationLevel level = UnstableApiAnnotationLevel.valueOf(levelValue);
            if (context.isNormalServer()) {
                context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                    protected void execute(DeploymentProcessorTarget processorTarget) {
                        processorTarget.addDeploymentProcessor("core-management", Phase.PARSE, 2112, (DeploymentUnitProcessor)new ScanUnstableApiAnnotationsProcessor(context.getRunningMode(), context.getStability(), level));
                        processorTarget.addDeploymentProcessor("core-management", Phase.PARSE, 2128, (DeploymentUnitProcessor)new ReportUnstableApiAnnotationsProcessor(level));
                    }
                }, OperationContext.Stage.RUNTIME);
            }
        }
    }
}

