/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ConfigUtil;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfig;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class FibonacciBackoffConfigImpl
implements FibonacciBackoffConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final FibonacciBackoff instance;
    private final boolean onMethod;
    private Long _maxDelay;
    private ChronoUnit _maxDelayUnit;

    private FibonacciBackoffConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.fibonacciBackoff;
        this.onMethod = method.annotationsPresentDirectly.contains(FibonacciBackoff.class);
    }

    public static FibonacciBackoffConfigImpl create(FaultToleranceMethod method) {
        if (method.fibonacciBackoff == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled(FibonacciBackoff.class, method.method)) {
            return null;
        }
        return new FibonacciBackoffConfigImpl(method);
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return FibonacciBackoff.class;
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public long maxDelay() {
        if (this._maxDelay == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelay", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelay", this.method.declaringClass, this.method.name);
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelay", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelay", this.method.declaringClass);
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDelay == null) {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelay");
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelay");
                this._maxDelay = config.getOptionalValue(newKey, Long.TYPE).or(() -> config.getOptionalValue(oldKey, Long.TYPE)).orElse(null);
            }
            if (this._maxDelay == null) {
                this._maxDelay = this.instance.maxDelay();
            }
        }
        return this._maxDelay;
    }

    public ChronoUnit maxDelayUnit() {
        if (this._maxDelayUnit == null) {
            String oldKey;
            String newKey;
            Config config = ConfigProvider.getConfig();
            if (this.onMethod) {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelayUnit", this.method.declaringClass, this.method.name);
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelayUnit", this.method.declaringClass, this.method.name);
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            } else {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelayUnit", this.method.declaringClass);
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelayUnit", this.method.declaringClass);
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                newKey = ConfigUtil.newKey(FibonacciBackoff.class, "maxDelayUnit");
                oldKey = ConfigUtil.oldKey(FibonacciBackoff.class, "maxDelayUnit");
                this._maxDelayUnit = config.getOptionalValue(newKey, ChronoUnit.class).or(() -> config.getOptionalValue(oldKey, ChronoUnit.class)).orElse(null);
            }
            if (this._maxDelayUnit == null) {
                this._maxDelayUnit = this.instance.maxDelayUnit();
            }
        }
        return this._maxDelayUnit;
    }

    public void materialize() {
        this.maxDelay();
        this.maxDelayUnit();
    }
}

