/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.util.HashMap;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.elytron.BaseAddHandler;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.ElytronDefinition;
import org.wildfly.extension.elytron.ElytronExtension;
import org.wildfly.extension.elytron.ElytronReloadRequiredWriteAttributeHandler;
import org.wildfly.extension.elytron.RegexAttributeDefinitions;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialCapabilityServiceRemoveHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.RealmMapper;
import org.wildfly.security.auth.util.MappedRegexRealmMapper;
import org.wildfly.security.auth.util.SimpleRegexRealmMapper;

class RealmMapperDefinitions {
    static final SimpleAttributeDefinition DELEGATE_REALM_MAPPER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("delegate-realm-mapper", ModelType.STRING, true).setMinSize(1)).setRestartAllServices()).setCapabilityReference("org.wildfly.security.realm-mapper", "org.wildfly.security.realm-mapper")).build();
    static final SimpleAttributeDefinition REALM_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("realm-name", ModelType.STRING, false).setMinSize(1)).setRestartAllServices()).build();
    static final PropertiesAttributeDefinition REALM_REALM_MAP = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("realm-map", false).setMinSize(1)).setAllowExpression(true)).setRestartAllServices()).build();
    static final AttributeDefinition[] CONSTANT_REALM_MAPPER_ATTRIBUTES = new AttributeDefinition[]{REALM_NAME};

    RealmMapperDefinitions() {
    }

    static ResourceDefinition getSimpleRegexRealmMapperDefinition() {
        return new SimpleRegexRealmMapperDefinition();
    }

    static ResourceDefinition getMappedRegexRealmMapper() {
        return new MappedRegexRealmMapperDefinition();
    }

    static ResourceDefinition getConstantRealmMapper() {
        TrivialAddHandler<RealmMapper> add = new TrivialAddHandler<RealmMapper>(RealmMapper.class, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<RealmMapper> getValueSupplier(ServiceBuilder<RealmMapper> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String realmName = REALM_NAME.resolveModelAttribute(context, model).asString();
                return () -> RealmMapper.single((String)realmName);
            }
        };
        return TrivialResourceDefinition.builder().setPathKey("constant-realm-mapper").setAddHandler(add).setAttributes(CONSTANT_REALM_MAPPER_ATTRIBUTES).setRuntimeCapabilities(Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY).build();
    }

    private static class MappedRegexRealmMapperAddHandler
    extends BaseAddHandler {
        private MappedRegexRealmMapperAddHandler() {
            super(Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmMapperName = runtimeCapability.getCapabilityServiceName(RealmMapper.class);
            String pattern = RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.resolveModelAttribute(context, model).asString();
            ModelNode realmMapList = REALM_REALM_MAP.resolveModelAttribute(context, model);
            Set names = realmMapList.keys();
            HashMap<String, String> realmRealmMap = new HashMap<String, String>(names.size());
            for (String s : names) {
                realmRealmMap.put(s, realmMapList.require(s).asString());
            }
            String delegateRealmMapper = DELEGATE_REALM_MAPPER.resolveModelAttribute(context, model).asStringOrNull();
            InjectedValue delegateRealmMapperInjector = new InjectedValue();
            TrivialService<RealmMapper> realmMapperService = new TrivialService<RealmMapper>(() -> {
                RealmMapper delegate = (RealmMapper)delegateRealmMapperInjector.getOptionalValue();
                Pattern compiledPattern = Pattern.compile(pattern);
                if (delegate == null) {
                    return new MappedRegexRealmMapper(compiledPattern, realmRealmMap);
                }
                return new MappedRegexRealmMapper(compiledPattern, delegate, realmRealmMap);
            });
            ServiceBuilder realmMapperBuilder = serviceTarget.addService(realmMapperName, realmMapperService);
            if (delegateRealmMapper != null) {
                String delegateCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)delegateRealmMapper);
                ServiceName delegateServiceName = context.getCapabilityServiceName(delegateCapabilityName, RealmMapper.class);
                realmMapperBuilder.addDependency(delegateServiceName, RealmMapper.class, (Injector)delegateRealmMapperInjector);
            }
            ElytronDefinition.commonDependencies(realmMapperBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class MappedRegexRealmMapperDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP, REALM_REALM_MAP, DELEGATE_REALM_MAPPER};
        private static final AbstractAddStepHandler ADD = new MappedRegexRealmMapperAddHandler();
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);

        private MappedRegexRealmMapperDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"mapped-regex-realm-mapper"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("mapped-regex-realm-mapper")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
            }
        }
    }

    private static class SimpleRegexRealmMapperAddHandler
    extends BaseAddHandler {
        private SimpleRegexRealmMapperAddHandler() {
            super(Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            ServiceTarget serviceTarget = context.getServiceTarget();
            RuntimeCapability runtimeCapability = Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY.fromBaseCapability(context.getCurrentAddressValue());
            ServiceName realmMapperName = runtimeCapability.getCapabilityServiceName(RealmMapper.class);
            String pattern = RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP.resolveModelAttribute(context, model).asString();
            String delegateRealmMapper = DELEGATE_REALM_MAPPER.resolveModelAttribute(context, model).asStringOrNull();
            InjectedValue delegateRealmMapperInjector = new InjectedValue();
            TrivialService<RealmMapper> realmMapperService = new TrivialService<RealmMapper>(() -> {
                RealmMapper delegate = (RealmMapper)delegateRealmMapperInjector.getOptionalValue();
                Pattern compiledPattern = Pattern.compile(pattern);
                if (delegate == null) {
                    return new SimpleRegexRealmMapper(compiledPattern);
                }
                return new SimpleRegexRealmMapper(compiledPattern, delegate);
            });
            ServiceBuilder realmMapperBuilder = serviceTarget.addService(realmMapperName, realmMapperService);
            if (delegateRealmMapper != null) {
                String delegateCapabilityName = RuntimeCapability.buildDynamicCapabilityName((String)"org.wildfly.security.realm-mapper", (String)delegateRealmMapper);
                ServiceName delegateServiceName = context.getCapabilityServiceName(delegateCapabilityName, RealmMapper.class);
                realmMapperBuilder.addDependency(delegateServiceName, RealmMapper.class, (Injector)delegateRealmMapperInjector);
            }
            ElytronDefinition.commonDependencies(realmMapperBuilder).setInitialMode(ServiceController.Mode.LAZY).install();
        }
    }

    private static class SimpleRegexRealmMapperDefinition
    extends SimpleResourceDefinition {
        private static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{RegexAttributeDefinitions.PATTERN_CAPTURE_GROUP, DELEGATE_REALM_MAPPER};
        private static final AbstractAddStepHandler ADD = new SimpleRegexRealmMapperAddHandler();
        private static final OperationStepHandler REMOVE = new TrivialCapabilityServiceRemoveHandler(ADD, Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY);

        private SimpleRegexRealmMapperDefinition() {
            super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"simple-regex-realm-mapper"), (ResourceDescriptionResolver)ElytronExtension.getResourceDescriptionResolver("simple-regex-realm-mapper")).setAddHandler((OperationStepHandler)ADD).setRemoveHandler(REMOVE).setAddRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setRemoveRestartLevel(OperationEntry.Flag.RESTART_RESOURCE_SERVICES).setCapabilities(new RuntimeCapability[]{Capabilities.REALM_MAPPER_RUNTIME_CAPABILITY}));
        }

        public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
            for (AttributeDefinition current : ATTRIBUTES) {
                resourceRegistration.registerReadWriteAttribute(current, null, ElytronReloadRequiredWriteAttributeHandler.INSTANCE);
            }
        }
    }
}

