/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.junit.jupiter.api.AfterEach;

public class AmqpTestSupport
extends ActiveMQTestBase {
    protected static final String BROKER_NAME = "localhost";
    protected static final String NETTY_ACCEPTOR = "netty-acceptor";
    protected static final String MULTICAST_PREFIX = "multicast://";
    protected static final String ANYCAST_PREFIX = "anycast://";
    protected String noprivUser = "noprivs";
    protected String noprivPass = "noprivs";
    protected String browseUser = "browser";
    protected String browsePass = "browser";
    protected String guestUser = "guest";
    protected String guestPass = "guest";
    protected String fullUser = "user";
    protected String fullPass = "pass";
    protected static final int AMQP_PORT = 5672;
    protected LinkedList<AmqpConnection> connections = new LinkedList();
    protected boolean useSSL;
    protected boolean useWebSockets;
    protected MBeanServer mBeanServer = this.createMBeanServer();

    protected AmqpConnection addConnection(AmqpConnection connection) {
        this.connections.add(connection);
        return connection;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        for (AmqpConnection conn : this.connections) {
            try {
                conn.close();
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        super.tearDown();
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean isUseWebSockets() {
        return this.useWebSockets;
    }

    public String getAmqpConnectionURIOptions() {
        return "";
    }

    public URI getBrokerAmqpConnectionURI() {
        boolean webSocket = this.isUseWebSockets();
        try {
            int port = 5672;
            String uri = null;
            uri = this.isUseSSL() ? (webSocket ? "wss://127.0.0.1:" + port : "ssl://127.0.0.1:" + port) : (webSocket ? "ws://127.0.0.1:" + port : "tcp://127.0.0.1:" + port);
            if (!this.getAmqpConnectionURIOptions().isEmpty()) {
                uri = uri + "?" + this.getAmqpConnectionURIOptions();
            }
            return new URI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public AmqpConnection createAmqpConnection() throws Exception {
        return this.createAmqpConnection(this.getBrokerAmqpConnectionURI());
    }

    public AmqpConnection createAmqpConnection(String username, String password) throws Exception {
        return this.createAmqpConnection(this.getBrokerAmqpConnectionURI(), username, password);
    }

    public AmqpConnection createAmqpConnection(URI brokerURI) throws Exception {
        return this.createAmqpConnection(brokerURI, null, null);
    }

    public AmqpConnection createAmqpConnection(URI brokerURI, String username, String password) throws Exception {
        return this.createAmqpClient(brokerURI, username, password).connect();
    }

    public AmqpClient createAmqpClient() throws Exception {
        return this.createAmqpClient(this.getBrokerAmqpConnectionURI(), null, null);
    }

    public AmqpClient createAmqpClient(URI brokerURI) throws Exception {
        return this.createAmqpClient(brokerURI, null, null);
    }

    public AmqpClient createAmqpClient(String username, String password) throws Exception {
        return this.createAmqpClient(this.getBrokerAmqpConnectionURI(), username, password);
    }

    public AmqpClient createAmqpClient(URI brokerURI, String username, String password) throws Exception {
        return new AmqpClient(brokerURI, username, password);
    }

    protected ActiveMQServer createServer(int port, boolean start) throws Exception {
        ActiveMQServer server = this.createServer(true, true);
        server.getConfiguration().getAcceptorConfigurations().clear();
        server.getConfiguration().getAcceptorConfigurations().add(this.addAcceptorConfiguration(server, port));
        server.getConfiguration().setName(BROKER_NAME);
        server.getConfiguration().setJournalDirectory(server.getConfiguration().getJournalDirectory() + port);
        server.getConfiguration().setBindingsDirectory(server.getConfiguration().getBindingsDirectory() + port);
        server.getConfiguration().setPagingDirectory(server.getConfiguration().getPagingDirectory() + port);
        if (port == 5672) {
            server.getConfiguration().setLargeMessagesDirectory(server.getConfiguration().getLargeMessagesDirectory());
        } else {
            server.getConfiguration().setLargeMessagesDirectory(server.getConfiguration().getLargeMessagesDirectory() + port);
        }
        server.getConfiguration().setJMXManagementEnabled(true);
        server.getConfiguration().setMessageExpiryScanPeriod(100L);
        server.setMBeanServer(this.mBeanServer);
        this.addAdditionalAcceptors(server);
        this.configureAddressPolicy(server);
        this.configureBrokerSecurity(server);
        this.addConfiguration(server);
        if (start) {
            server.start();
            this.createAddressAndQueues(server);
        }
        return server;
    }

    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
    }

    protected void addConfiguration(ActiveMQServer server) {
    }

    protected void addAdditionalAcceptors(ActiveMQServer server) throws Exception {
    }

    protected void configureAddressPolicy(ActiveMQServer server) {
    }

    protected TransportConfiguration addAcceptorConfiguration(ActiveMQServer server, int port) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("port", String.valueOf(port));
        params.put("protocols", this.getConfiguredProtocols());
        HashMap<String, Object> amqpParams = new HashMap<String, Object>();
        this.configureAMQPAcceptorParameters(amqpParams);
        TransportConfiguration tc = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, NETTY_ACCEPTOR, amqpParams);
        this.configureAMQPAcceptorParameters(tc);
        return tc;
    }

    protected String getConfiguredProtocols() {
        return "AMQP,OPENWIRE";
    }

    protected void configureAMQPAcceptorParameters(Map<String, Object> params) {
    }

    protected void configureAMQPAcceptorParameters(TransportConfiguration tc) {
    }

    protected void configureBrokerSecurity(ActiveMQServer server) {
    }
}

