/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp.connect;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Divert;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.ActiveMQServerAMQPFederationPlugin;
import org.apache.activemq.artemis.protocol.amqp.federation.Federation;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.LinkError;
import org.apache.qpid.protonj2.test.driver.ProtonTestClient;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ProtonTestServer;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Source;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.transport.Attach;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferPayloadCompositeMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPFederationAddressPolicyTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();

    @Override
    protected String getConfiguredProtocols() {
        return "AMQP,CORE";
    }

    @Override
    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672, false);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverWhenLocalQueueIsStaticlyDefined() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSenderSettleModeSettled().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().respond();
            logger.info("Removing Queues from federated address to eliminate demand");
            this.server.destroyQueue(SimpleString.of((String)"test"));
            Wait.assertFalse(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverLinkForAddressMatch() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverLinkForAddressMatchUsingPolicyCredit() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.addProperty("amqpCredits", "25");
            receiveFromAddress.addProperty("amqpLowCredits", "5");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(25);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverLinkForAddressMatchWithMaxHopsFilter() throws Exception {
        this.doTestFederationCreatesAddressReceiverLinkForAddressWithCorrectFilters(true);
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverLinkForAddressMatchWithoutMaxHopsFilter() throws Exception {
        this.doTestFederationCreatesAddressReceiverLinkForAddressWithCorrectFilters(false);
    }

    private void doTestFederationCreatesAddressReceiverLinkForAddressWithCorrectFilters(boolean maxHops) throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            if (maxHops) {
                receiveFromAddress.setMaxHops(1);
            } else {
                receiveFromAddress.setMaxHops(0);
            }
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            String expectedJMSFilter = AMQPFederationPolicySupport.generateAddressFilter((int)1);
            Symbol jmsSelectorKey = Symbol.valueOf((String)"jms-selector");
            Symbol noLocalKey = Symbol.valueOf((String)"apache.org:no-local-filter:list");
            UnsignedLong noLocalCode = UnsignedLong.valueOf((long)77567109365763L);
            UnsignedLong jmsSelectorCode = UnsignedLong.valueOf((long)77567109365764L);
            HashMap<String, Object> selectors = new HashMap<String, Object>();
            selectors.put(AmqpSupport.JMS_SELECTOR_KEY.toString(), new AmqpJmsSelectorFilter(expectedJMSFilter));
            selectors.put(AmqpSupport.NO_LOCAL_NAME.toString(), new AmqpNoLocalFilter());
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            AtomicReference capturedAttach = new AtomicReference();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).withCapture(attach -> capturedAttach.set(attach)).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            try (ProtonTestClient receivingPeer = new ProtonTestClient();){
                receivingPeer.queueClientSaslAnonymousConnect();
                receivingPeer.connect("localhost", 5672);
                receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                receivingPeer.expectOpen();
                receivingPeer.expectBegin();
                receivingPeer.expectAttach();
                receivingPeer.remoteOpen().withContainerId("test-sender").now();
                receivingPeer.remoteBegin().now();
                receivingPeer.remoteAttach().ofReceiver().withInitialDeliveryCount(0L).withName("sending-peer").withSource().withAddress("test").withCapabilities(new String[]{"topic"}).also().withTarget().also().now();
                receivingPeer.remoteFlow().withLinkCredit(10L).now();
                receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull(capturedAttach.get());
                Source remoteSource = ((Attach)capturedAttach.get()).getSource();
                Assertions.assertNotNull((Object)remoteSource);
                Map filtersMap = remoteSource.getFilter();
                Assertions.assertNotNull((Object)filtersMap);
                if (maxHops) {
                    Assertions.assertTrue((boolean)filtersMap.containsKey(jmsSelectorKey));
                    DescribedType jmsSelectorEntry = (DescribedType)filtersMap.get(jmsSelectorKey);
                    Assertions.assertNotNull((Object)jmsSelectorEntry);
                    Assertions.assertEquals((Object)jmsSelectorEntry.getDescriptor(), (Object)jmsSelectorCode);
                    Assertions.assertEquals((Object)jmsSelectorEntry.getDescribed().toString(), (Object)expectedJMSFilter);
                } else {
                    Assertions.assertFalse((boolean)filtersMap.containsKey(jmsSelectorKey));
                }
                Assertions.assertTrue((boolean)filtersMap.containsKey(noLocalKey));
                DescribedType noLocalEntry = (DescribedType)filtersMap.get(noLocalKey);
                Assertions.assertNotNull((Object)noLocalEntry);
                Assertions.assertEquals((Object)noLocalEntry.getDescriptor(), (Object)noLocalCode);
                HeaderMatcher headerMatcher = new HeaderMatcher(true);
                MessageAnnotationsMatcher annotationsMatcher = new MessageAnnotationsMatcher(true);
                annotationsMatcher.withEntry("x-opt-test", Matchers.equalTo((Object)"test"));
                annotationsMatcher.withEntry(AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION.toString(), Matchers.equalTo((Object)1));
                EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher((Object)"Hello World");
                TransferPayloadCompositeMatcher matcher = new TransferPayloadCompositeMatcher();
                matcher.setHeadersMatcher(headerMatcher);
                matcher.setMessageAnnotationsMatcher(annotationsMatcher);
                matcher.addMessageContentMatcher((Matcher)bodyMatcher);
                receivingPeer.expectTransfer().withPayload((Matcher)matcher).accept();
                peer.expectDisposition().withState().accepted();
                peer.remoteTransfer().withHeader().withDurability(true).also().withMessageAnnotations().withAnnotation("x-opt-test", (Object)"test").also().withBody().withString("Hello World").also().withDeliveryId(1).now();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                receivingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationClosesAddressReceiverLinkWhenDemandRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationRetainsAddressReceiverLinkWhenDurableSubscriberIsOffline() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                connection.setClientID("test-clientId");
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("test");
                MessageConsumer consumer = session.createSharedDurableConsumer(topic, "shared-subscription");
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                session.unsubscribe("shared-subscription");
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationClosesAddressReceiverLinkWaitsForAllDemandToRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer1 = session.createConsumer((Destination)session.createTopic("test"));
                MessageConsumer consumer2 = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationHandlesAddressDeletedAndConsumerRecreates() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            Session session;
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                this.server.removeAddressInfo(SimpleString.of((String)"test"), null, true);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000).optional();
            connection = factory.createConnection();
            try {
                session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.expectDetach().respond();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConsumerCreatedWhenDemandAddedToDivertAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("test").setForwardingAddress("forward").setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("forward"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConsumerCreatedWhenDemandAddedToCompositeDivertAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("test").setForwardingAddress("forward1,forward2").setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer1 = session.createConsumer((Destination)session.createTopic("forward1"));
                MessageConsumer consumer2 = session.createConsumer((Destination)session.createTopic("forward2"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConsumerRemovesDemandFromDivertConsumersOnlyWhenAllDemandIsRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("test").setForwardingAddress("forward").setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer1 = session.createConsumer((Destination)session.createTopic("forward"));
                MessageConsumer consumer2 = session.createConsumer((Destination)session.createTopic("forward"));
                connection.start();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConsumerRetainsDemandForDivertBindingWithoutActiveAnycastSubscriptions() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("source");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("source").setForwardingAddress("forward").setRoutingType(ComponentConfigurationRoutingType.ANYCAST).setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"source"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Queue queue = session.createQueue("forward");
                MessageConsumer consumer1 = session.createConsumer((Destination)queue);
                MessageConsumer consumer2 = session.createConsumer((Destination)queue);
                connection.start();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationConsumerRemovesDemandForDivertBindingWithoutActiveMulticastSubscriptions() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("source");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("source").setForwardingAddress("forward").setRoutingType(ComponentConfigurationRoutingType.MULTICAST).setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"source"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("forward");
                MessageConsumer consumer1 = session.createConsumer((Destination)topic);
                MessageConsumer consumer2 = session.createConsumer((Destination)topic);
                connection.start();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationRemovesRemoteDemandIfDivertIsRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("source");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("source").setForwardingAddress("forward").setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"source"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"source"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("forward"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                this.server.destroyDivert(SimpleString.of((String)"test-divert"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testDivertBindingsDoNotCreateAdditionalDemandIfDemandOnForwardingAddressAlreadyExists() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divertConfig = new DivertConfiguration().setAddress("test").setForwardingAddress("forward").setName("test-divert");
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.deployDivert(divertConfig);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                MessageConsumer consumer1 = session.createConsumer((Destination)session.createTopic("forward"));
                MessageConsumer consumer2 = session.createConsumer((Destination)session.createTopic("forward"));
                consumer1.close();
                consumer2.close();
                this.server.destroyDivert(SimpleString.of((String)"test-divert"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testInboundMessageRoutedToReceiverOnLocalAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(0).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAcceptsAddressPolicyFromControlLink() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        includes.add("address2");
        ArrayList excludes = new ArrayList();
        includes.add("address3");
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, excludes, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAcceptsAddressPolicyFromControlLinkWithTransformerConfiguration() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        includes.add("address2");
        ArrayList excludes = new ArrayList();
        includes.add("address3");
        HashMap<String, String> transformerProperties = new HashMap<String, String>();
        transformerProperties.put("key1", "value1");
        transformerProperties.put("key2", "value2");
        TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
        transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
        transformerConfiguration.setProperties(transformerProperties);
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, excludes, null, transformerConfiguration, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesAddressWhenDemandIsApplied() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, null, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withSource().withAddress("address1").and().respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("address1"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesAddressWhenDemandIsAppliedUsingControllerDefinedLinkCredit() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, null, null, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test", 10, 9);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withSource().withAddress("address1").and().respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectFlow().withLinkCredit(10);
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("address1"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesAddressWhenDemandIsAppliedUsingPolicyDefinedLinkCredit() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("amqpCredits", 40);
        properties.put("amqpLowCredits", "39");
        properties.put("minLargeMessageSize", 1024);
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, null, properties, null, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test", 10, 9);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withSource().withAddress("address1").and().respondInKind();
            peer.expectFlow().withLinkCredit(40);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectFlow().withLinkCredit(40);
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("address1"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteFederatesAddressAndAppliesTransformerWhenDemandIsApplied() throws Exception {
        this.server.start();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("address1");
        HashMap<String, String> transformerProperties = new HashMap<String, String>();
        transformerProperties.put("key1", "value1");
        transformerProperties.put("key2", "value2");
        TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
        transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
        transformerConfiguration.setProperties(transformerProperties);
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy("test-address-policy", true, 30000L, 1000L, 1, true, includes, null, null, transformerConfiguration, DEFAULT_WILDCARD_CONFIGURATION);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDisposition().withSettled(true).withState().accepted();
            AMQPFederationAddressPolicyTest.sendAddresPolicyToRemote(peer, policy);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withSource().withAddress("address1").and().respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(1).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("address1"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                Assertions.assertEquals((Object)"value1", (Object)message.getStringProperty("key1"));
                Assertions.assertEquals((Object)"value2", (Object)message.getStringProperty("key2"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerAnswersAttachOfFederationReceiverProperly() throws Exception {
        this.server.start();
        HashMap<String, Comparable<Boolean>> remoteSourceProperties = new HashMap<String, Comparable<Boolean>>();
        remoteSourceProperties.put("auto-delete", Boolean.valueOf(true));
        remoteSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
        remoteSourceProperties.put("auto-delete-msg-count", Long.valueOf(1L));
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withTarget().also().withSource().withAddress("test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), remoteSourceProperties).withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testReceiverWithMaxHopsFilterAppliesFilterCorrectly() throws Exception {
        this.server.start();
        String maxHopsJMSFilter = "\"m." + AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION + "\" IS NULL OR \"m." + AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION + "\"<2";
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withSource().withAddress("test").withJMSSelector(maxHopsJMSFilter);
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).withJMSSelector(maxHopsJMSFilter).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            HeaderMatcher headerMatcher = new HeaderMatcher(true);
            MessageAnnotationsMatcher annotationsMatcher = new MessageAnnotationsMatcher(true);
            PropertiesMatcher properties = new PropertiesMatcher(true);
            EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher((Object)"Hello World");
            TransferPayloadCompositeMatcher matcher = new TransferPayloadCompositeMatcher();
            matcher.setHeadersMatcher(headerMatcher);
            matcher.setMessageAnnotationsMatcher(annotationsMatcher);
            matcher.setPropertiesMatcher(properties);
            matcher.addMessageContentMatcher((Matcher)bodyMatcher);
            peer.expectTransfer().withPayload((Matcher)matcher).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createTopic("test"));
                producer.send((Message)session.createTextMessage("Hello World"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectTransfer().withPayload((Matcher)matcher).accept();
            try (ProtonTestClient sendingPeer = new ProtonTestClient();){
                sendingPeer.queueClientSaslAnonymousConnect();
                sendingPeer.connect("localhost", 5672);
                sendingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                sendingPeer.expectOpen();
                sendingPeer.expectBegin();
                sendingPeer.expectAttach();
                sendingPeer.expectFlow();
                sendingPeer.remoteOpen().withContainerId("test-sender").now();
                sendingPeer.remoteBegin().now();
                sendingPeer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName("sending-peer").withTarget().withAddress("test").withCapabilities(new String[]{"topic"}).also().withSource().also().now();
                sendingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                sendingPeer.expectDisposition().withSettled(true).withState().accepted();
                sendingPeer.expectDisposition().withSettled(true).withState().accepted();
                sendingPeer.remoteTransfer().withDeliveryId(0).withHeader().withDurability(false).also().withProperties().withMessageId((Object)"ID:1").also().withMessageAnnotations().withAnnotation(AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION.toString(), (Object)1).also().withBody().withString("Hello World").also().now();
                sendingPeer.remoteTransfer().withDeliveryId(1).withHeader().withDurability(false).also().withProperties().withMessageId((Object)"ID:2").also().withMessageAnnotations().withAnnotation(AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION.toString(), (Object)2).also().withBody().withString("Hello World").also().now();
                sendingPeer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteConnectionCannotAttachAddressFederationLinkWithoutControlLink() throws Exception {
        this.server.start();
        try (ProtonTestClient peer = new ProtonTestClient();){
            peer.queueClientSaslAnonymousConnect();
            peer.remoteOpen().queue();
            peer.expectOpen();
            peer.remoteBegin().queue();
            peer.expectBegin();
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withSource(CoreMatchers.nullValue()).withTarget();
            peer.expectDetach().respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testTransformInboundFederatedMessageBeforeDispatch() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            HashMap<String, String> newApplicationProperties = new HashMap<String, String>();
            newApplicationProperties.put("appProperty1", "one");
            newApplicationProperties.put("appProperty2", "two");
            TransformerConfiguration transformerConfiguration = new TransformerConfiguration();
            transformerConfiguration.setClassName(ApplicationPropertiesTransformer.class.getName());
            transformerConfiguration.setProperties(newApplicationProperties);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.setTransformerConfiguration(transformerConfiguration);
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respondInKind();
            peer.expectFlow().withLinkCredit(1000);
            peer.remoteTransfer().withBody().withString("test-message").also().withDeliveryId(0).queue();
            peer.expectDisposition().withSettled(true).withState().accepted();
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertTrue((boolean)(message instanceof TextMessage));
                Assertions.assertEquals((Object)"test-message", (Object)((TextMessage)message).getText());
                Assertions.assertEquals((Object)"one", (Object)message.getStringProperty("appProperty1"));
                Assertions.assertEquals((Object)"two", (Object)message.getStringProperty("appProperty2"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach();
            }
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationDoesNotCreateAddressReceiverLinkForAddressMatchWhenLinkCreditIsSetToZero() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort() + "?amqpCredits=0");
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                Assertions.assertNull((Object)consumer.receiveNoWait());
                consumer.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageConvertedToAMQPWhenTunnelingDisabled() throws Exception {
        this.doTestCoreMessageHandlingBasedOnTunnelingState(false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreMessageNotConvertedToAMQPWhenTunnelingEnabled() throws Exception {
        this.doTestCoreMessageHandlingBasedOnTunnelingState(true);
    }

    private void doTestCoreMessageHandlingBasedOnTunnelingState(boolean tunneling) throws Exception {
        int messageFormat;
        String[] receiverOfferedCapabilities;
        this.server.start();
        if (tunneling) {
            receiverOfferedCapabilities = new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()};
            messageFormat = 1183580416;
        } else {
            receiverOfferedCapabilities = null;
            messageFormat = 0;
        }
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withDesiredCapabilities(new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()}).withSource().withAddress("test");
            peer.remoteAttach().ofReceiver().withOfferedCapabilities(receiverOfferedCapabilities).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withNonNullPayload().withMessageFormat(messageFormat).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672?minLargeMessageSize=512");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createTopic("test"));
                producer.send((Message)session.createTextMessage("Hello World"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testCoreLargeMessageConvertedToAMQPWhenTunnelingDisabled() throws Exception {
        this.doTestCoreLargeMessageHandlingBasedOnTunnelingState(false);
    }

    @Test
    @Timeout(value=20L)
    public void testCoreLargeMessageNotConvertedToAMQPWhenTunnelingEnabled() throws Exception {
        this.doTestCoreLargeMessageHandlingBasedOnTunnelingState(true);
    }

    private void doTestCoreLargeMessageHandlingBasedOnTunnelingState(boolean tunneling) throws Exception {
        int messageFormat;
        String[] receiverOfferedCapabilities;
        this.server.start();
        if (tunneling) {
            receiverOfferedCapabilities = new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()};
            messageFormat = 1183580672;
        } else {
            receiverOfferedCapabilities = null;
            messageFormat = 0;
        }
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withDesiredCapabilities(new String[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT.toString()}).withSource().withAddress("test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withOfferedCapabilities(receiverOfferedCapabilities).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.remoteFlow().withLinkCredit(10L).now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withNonNullPayload().withMessageFormat(messageFormat).accept();
            ConnectionFactory factory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:5672?minLargeMessageSize=512");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageProducer producer = session.createProducer((Destination)session.createTopic("test"));
                byte[] payload = new byte[1024];
                Arrays.fill(payload, (byte)65);
                BytesMessage message = session.createBytesMessage();
                message.writeBytes(payload);
                producer.send((Message)message);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            }
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationStartedTriggersRemoteDemandWithExistingAddressBindings() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setAutostart(false);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            Wait.assertTrue(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            session.createConsumer((Destination)session.createTopic("test"));
            session.createConsumer((Destination)session.createTopic("test"));
            session.createConsumer((Destination)session.createTopic("a1"));
            session.createConsumer((Destination)session.createTopic("a2"));
            connection.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            this.server.getBrokerConnections().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            session.createConsumer((Destination)session.createTopic("test"));
            session.createConsumer((Destination)session.createTopic("test"));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            connection.close();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().respond();
            logger.info("Removing Queues from federated address to eliminate demand");
            this.server.destroyQueue(SimpleString.of((String)"test"));
            Wait.assertFalse(() -> this.server.queueQuery(SimpleString.of((String)"test")).isExists());
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationStartedTriggersRemoteDemandWithExistingAddressAndDivertBindings() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setAutostart(false);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divert = new DivertConfiguration();
            divert.setName("test-divert");
            divert.setAddress("test");
            divert.setExclusive(false);
            divert.setForwardingAddress("target");
            divert.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"target"), RoutingType.MULTICAST));
            this.server.deployDivert(divert);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            Topic test = session.createTopic("test");
            Topic target = session.createTopic("target");
            session.createConsumer((Destination)test);
            session.createConsumer((Destination)test);
            session.createConsumer((Destination)target);
            session.createConsumer((Destination)target);
            session.createConsumer((Destination)session.createTopic("a1"));
            session.createConsumer((Destination)session.createTopic("a2"));
            connection.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            this.server.getBrokerConnections().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            session.createConsumer((Destination)test);
            session.createConsumer((Destination)target);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().respond();
            connection.close();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationStartTriggersFederationWithMultipleDivertsAndRemainsActiveAfterOneRemoved() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.setAutostart(false);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divert1 = new DivertConfiguration();
            divert1.setName("test-divert-1");
            divert1.setAddress("test");
            divert1.setExclusive(false);
            divert1.setForwardingAddress("target1,target2");
            divert1.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
            DivertConfiguration divert2 = new DivertConfiguration();
            divert2.setName("test-divert-2");
            divert2.setAddress("test");
            divert2.setExclusive(false);
            divert2.setForwardingAddress("target1,target3");
            divert2.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"target1"), RoutingType.MULTICAST));
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"target2"), RoutingType.MULTICAST));
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"target3"), RoutingType.MULTICAST));
            this.server.deployDivert(divert1);
            this.server.deployDivert(divert2);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            Topic target1 = session.createTopic("target1");
            Topic target2 = session.createTopic("target2");
            Topic target3 = session.createTopic("target2");
            session.createConsumer((Destination)target1);
            session.createConsumer((Destination)target2);
            session.createConsumer((Destination)target3);
            connection.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            this.server.getBrokerConnections().forEach(c -> {
                try {
                    c.start();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            session.createConsumer((Destination)target1);
            session.createConsumer((Destination)target2);
            session.createConsumer((Destination)target3);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.destroyDivert(SimpleString.of((String)divert1.getName()));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().respond();
            this.server.destroyDivert(SimpleString.of((String)divert2.getName()));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            connection.close();
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationPluginCanLimitDemandToOnlyTheConfiguredDivert() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setEnableDivertBindings(Boolean.valueOf(true));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(5);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            DivertConfiguration divert = new DivertConfiguration();
            divert.setName("test-divert-1");
            divert.setAddress("test");
            divert.setExclusive(false);
            divert.setForwardingAddress("target");
            divert.setRoutingType(ComponentConfigurationRoutingType.MULTICAST);
            AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
            federationPlugin.shouldCreateConsumerForDivert = (d, q) -> true;
            federationPlugin.shouldCreateConsumerForQueue = q -> {
                if (q.getAddress().toString().equals("test")) {
                    return false;
                }
                return true;
            };
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"target"), RoutingType.MULTICAST));
            this.server.deployDivert(divert);
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                consumer.receiveNoWait();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
                peer.expectFlow().withLinkCredit(1000);
                session.createConsumer((Destination)session.createTopic("target"));
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesEventSenderAndReceiverWhenLocalAndRemotePoliciesAdded() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_ADDRESS_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("test");
        policyMap.put("policy-name", "remote-address-policy");
        policyMap.put("auto-delete", false);
        policyMap.put("auto-delete-delay", -1L);
        policyMap.put("auto-delete-msg-count", -1L);
        policyMap.put("max-hops", 5);
        policyMap.put("enable-divert-bindings", false);
        policyMap.put("address-includes", includes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events-sender");
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withSource().withAddress("test-dynamic-events-receiver");
            peer.expectFlow().withLinkCredit(10);
            peer.remoteFlow().withLinkCredit(10L).withHandle(0L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement localReceiveFromAddress = new AMQPFederationAddressPolicyElement();
            localReceiveFromAddress.setName("address-policy");
            localReceiveFromAddress.addToIncludes("test");
            localReceiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            localReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            localReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederationAddressPolicyElement remoteReceiveFromAddress = new AMQPFederationAddressPolicyElement();
            remoteReceiveFromAddress.setName("remote-address-policy");
            remoteReceiveFromAddress.addToIncludes("test");
            remoteReceiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            remoteReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            remoteReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            remoteReceiveFromAddress.setMaxHops(5);
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(localReceiveFromAddress);
            element.addRemoteAddressPolicy(remoteReceiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationSendsRemotePolicyIfEventsSenderLinkRejected() throws Exception {
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.OPERATION_TYPE.toString(), Matchers.is((Object)"ADD_ADDRESS_POLICY"));
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("test");
        policyMap.put("policy-name", "remote-address-policy");
        policyMap.put("auto-delete", false);
        policyMap.put("auto-delete-delay", -1L);
        policyMap.put("auto-delete-msg-count", -1L);
        policyMap.put("max-hops", 5);
        policyMap.put("enable-divert-bindings", false);
        policyMap.put("address-includes", includes);
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(policyMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofSender().withTarget().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).reject(true, LinkError.DETACH_FORCED.toString(), "Unknown error");
            peer.expectDetach();
            peer.remoteFlow().withLinkCredit(10L).withHandle(0L).queue();
            peer.expectTransfer().withPayload((Matcher)payloadMatcher);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement remoteReceiveFromAddress = new AMQPFederationAddressPolicyElement();
            remoteReceiveFromAddress.setName("remote-address-policy");
            remoteReceiveFromAddress.addToIncludes("test");
            remoteReceiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            remoteReceiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            remoteReceiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            remoteReceiveFromAddress.setMaxHops(5);
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addRemoteAddressPolicy(remoteReceiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerSendsAddressAddedEventForInterestedPeer() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoCreateQueues(Boolean.valueOf(false));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getConfiguration().getAddressSettings().put("#", addressSettings);
        this.server.start();
        HashMap<String, Comparable<Boolean>> remoteSourceProperties = new HashMap<String, Comparable<Boolean>>();
        remoteSourceProperties.put("auto-delete", Boolean.valueOf(true));
        remoteSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
        remoteSourceProperties.put("auto-delete-msg-count", Long.valueOf(1L));
        MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
        maMatcher.withEntry(AMQPFederationConstants.EVENT_TYPE.toString(), Matchers.is((Object)"REQUESTED_ADDRESS_ADDED_EVENT"));
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        eventMap.put("REQUESTED_ADDRESS_NAME", "test");
        EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(eventMap);
        TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
        payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
        payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test", false, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withTarget().also().withNullSource();
            peer.expectDetach().respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), remoteSourceProperties).withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectTransfer().withPayload((Matcher)payloadMatcher).accept();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationCreatesAddressReceiverInResponseToAddressAddedEvent() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.remoteFlow().withLinkCredit(10L);
            peer.expectAttach().ofReceiver().withHandle(1).withSenderSettleModeSettled().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(false));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(-1L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(false));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(-1L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withNullSource().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.remoteDetach().withClosed(true).withErrorCondition(AmqpError.NOT_FOUND.toString(), "Address not found").queue();
            peer.expectFlow().optional();
            peer.expectDetach();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            AMQPFederationAddressPolicyTest.sendAddressAddedEvent((ProtonTestPeer)peer, "target", 1, 0);
            AMQPFederationAddressPolicyTest.sendAddressAddedEvent((ProtonTestPeer)peer, "test", 1, 1);
            AMQPFederationAddressPolicyTest.sendAddressAddedEvent((ProtonTestPeer)peer, "test", 1, 2);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddressAddedEventIgnoredIfFederationConsumerAlreadyCreated() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withHandle(0).withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respondInKind();
            peer.remoteFlow().withLinkCredit(10L);
            peer.expectAttach().ofReceiver().withHandle(1).withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respond().withNullSource().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.remoteDetach().withClosed(true).withErrorCondition(AmqpError.NOT_FOUND.toString(), "Address not found").queue();
            peer.expectFlow().optional();
            peer.expectDetach();
            this.server.createQueue(QueueConfiguration.of((String)"test").setRoutingType(RoutingType.MULTICAST).setAddress("test").setAutoCreated(Boolean.valueOf(false)));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(1000);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            Connection connection = factory.createConnection();
            Session session = connection.createSession(1);
            session.createConsumer((Destination)session.createTopic("test"));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            AMQPFederationAddressPolicyTest.sendAddressAddedEvent((ProtonTestPeer)peer, "test", 1, 0);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testRemoteBrokerClosesFederationReceiverAfterAddressRemoved() throws Exception {
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test", true, true);
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withSource().withAddress("test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectDetach().withError(AmqpError.RESOURCE_DELETED.toString());
            this.server.removeAddressInfo(SimpleString.of((String)"test"), null, true);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            MessageAnnotationsMatcher maMatcher = new MessageAnnotationsMatcher(true);
            maMatcher.withEntry(AMQPFederationConstants.EVENT_TYPE.toString(), Matchers.is((Object)"REQUESTED_ADDRESS_ADDED_EVENT"));
            LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
            eventMap.put("REQUESTED_ADDRESS_NAME", "test");
            EncodedAmqpValueMatcher bodyMatcher = new EncodedAmqpValueMatcher(eventMap);
            TransferPayloadCompositeMatcher payloadMatcher = new TransferPayloadCompositeMatcher();
            payloadMatcher.setMessageAnnotationsMatcher(maMatcher);
            payloadMatcher.addMessageContentMatcher((Matcher)bodyMatcher);
            peer.expectTransfer().withPayload((Matcher)payloadMatcher).withSettled(true);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.removeAddressInfo(SimpleString.of((String)"test"), null, true);
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationAddressDemandTrackedWhenRemoteRejectsInitialAttempts() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("test");
                connection.start();
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respondInKind().withNullSource();
                peer.expectFlow().withLinkCredit(1000);
                peer.remoteDetach().withErrorCondition("amqp:not-found", "the requested queue was not found").queue().afterDelay(10);
                peer.expectDetach();
                MessageConsumer consumer1 = session.createConsumer((Destination)topic);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respondInKind().withNullSource();
                peer.expectFlow().withLinkCredit(1000);
                peer.remoteDetach().withErrorCondition("amqp:not-found", "the requested queue was not found").queue().afterDelay(10);
                peer.expectDetach();
                MessageConsumer consumer2 = session.createConsumer((Destination)topic);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                MessageConsumer consumer3 = session.createConsumer((Destination)topic);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer3.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testFederationAddressDemandTrackedWhenPluginBlocksInitialAttempts() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind();
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Connect test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            AtomicInteger blockUntilZero = new AtomicInteger(2);
            AMQPTestFederationBrokerPlugin federationPlugin = new AMQPTestFederationBrokerPlugin();
            federationPlugin.shouldCreateConsumerForDivert = (d, q) -> true;
            federationPlugin.shouldCreateConsumerForQueue = q -> true;
            federationPlugin.shouldCreateConsumerForAddress = a -> blockUntilZero.getAndDecrement() == 0;
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.registerBrokerPlugin((ActiveMQServerBasePlugin)federationPlugin);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                Topic topic = session.createTopic("test");
                connection.start();
                MessageConsumer consumer1 = session.createConsumer((Destination)topic);
                MessageConsumer consumer2 = session.createConsumer((Destination)topic);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).respondInKind();
                peer.expectFlow().withLinkCredit(1000);
                MessageConsumer consumer3 = session.createConsumer((Destination)topic);
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer3.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                consumer2.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.expectDetach().respond();
                consumer1.close();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    @Test
    @Timeout(value=20L)
    public void testBrokerAllowsAttachToPreviouslyNonExistentAddressAfterItIsAdded() throws Exception {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(false));
        this.server.getConfiguration().getAddressSettings().put("#", addressSettings);
        this.server.start();
        HashMap<String, Boolean> remoteSourceProperties = new HashMap<String, Boolean>();
        remoteSourceProperties.put("auto-delete", false);
        try (ProtonTestClient peer = new ProtonTestClient();){
            AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, "test");
            peer.connect("localhost", 5672);
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withTarget().also().withNullSource();
            peer.expectDetach().respond();
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), remoteSourceProperties).withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            this.server.addAddressInfo(new AddressInfo("test").addRoutingType(RoutingType.MULTICAST));
            peer.expectAttach().ofSender().withName("federation-address-receiver").withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withTarget().also().withSource().withAddress("test");
            peer.remoteAttach().ofReceiver().withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()}).withName("federation-address-receiver").withSenderSettleModeUnsettled().withReceivervSettlesFirst().withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), remoteSourceProperties).withSource().withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withAddress("test").withCapabilities(new String[]{"topic"}).and().withTarget().and().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectClose();
            peer.remoteClose().now();
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.close();
            this.server.stop();
        }
    }

    @Test
    @Timeout(value=20L)
    public void testAddressPolicyCanOverridesZeroCreditsInFederationConfigurationAndFederateAddress() throws Exception {
        try (ProtonTestServer peer = new ProtonTestServer();){
            peer.expectSASLAnonymousConnect();
            peer.expectOpen().respond();
            peer.expectBegin().respond();
            peer.expectAttach().ofSender().withDesiredCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()});
            peer.expectAttach().ofReceiver().withSource().withDynamic(true).and().withDesiredCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()).respondInKind().withTarget().withAddress("test-dynamic-events");
            peer.expectFlow().withLinkCredit(10);
            peer.start();
            URI remoteURI = peer.getServerURI();
            logger.info("Test started, peer listening on: {}", (Object)remoteURI);
            AMQPFederationAddressPolicyElement receiveFromAddress = new AMQPFederationAddressPolicyElement();
            receiveFromAddress.setName("address-policy");
            receiveFromAddress.addToIncludes("test");
            receiveFromAddress.setAutoDelete(Boolean.valueOf(true));
            receiveFromAddress.setAutoDeleteDelay(Long.valueOf(10000L));
            receiveFromAddress.setAutoDeleteMessageCount(Long.valueOf(-1L));
            receiveFromAddress.addProperty("amqpCredits", (Number)10);
            receiveFromAddress.addProperty("amqpLowCredits", (Number)3);
            AMQPFederatedBrokerConnectionElement element = new AMQPFederatedBrokerConnectionElement();
            element.setName(this.getTestName());
            element.addLocalAddressPolicy(receiveFromAddress);
            element.addProperty("amqpCredits", (Number)0);
            AMQPBrokerConnectConfiguration amqpConnection = new AMQPBrokerConnectConfiguration(this.getTestName(), "tcp://" + remoteURI.getHost() + ":" + remoteURI.getPort());
            amqpConnection.setReconnectAttempts(0);
            amqpConnection.addElement((AMQPBrokerConnectionElement)element);
            this.server.getConfiguration().addAMQPConnection(amqpConnection);
            this.server.start();
            this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
            HashMap<String, Comparable<Boolean>> expectedSourceProperties = new HashMap<String, Comparable<Boolean>>();
            expectedSourceProperties.put("auto-delete", Boolean.valueOf(true));
            expectedSourceProperties.put("auto-delete-delay", Long.valueOf(10000L));
            expectedSourceProperties.put("auto-delete-msg-count", Long.valueOf(-1L));
            peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
            peer.expectAttach().ofReceiver().withDesiredCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()).withName(CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.containsString((String)this.getTestName()), CoreMatchers.containsString((String)"test"), CoreMatchers.containsString((String)"address-receiver"), CoreMatchers.containsString((String)this.server.getNodeID().toString())})).withProperty(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES.toString(), expectedSourceProperties).respond().withOfferedCapabilities(new String[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString()});
            peer.expectFlow().withLinkCredit(10);
            ConnectionFactory factory = CFUtil.createConnectionFactory("AMQP", "tcp://localhost:5672");
            try (Connection connection = factory.createConnection();){
                Session session = connection.createSession(1);
                session.createConsumer((Destination)session.createTopic("test"));
                connection.start();
                peer.waitForScriptToComplete(5L, TimeUnit.SECONDS);
                peer.close();
            }
        }
    }

    private static void sendAddressAddedEvent(ProtonTestPeer peer, String address, int handle, int deliveryId) {
        LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
        eventMap.put("REQUESTED_ADDRESS_NAME", address);
        peer.remoteTransfer().withHandle((long)handle).withDeliveryId(deliveryId).withSettled(true).withMessageAnnotations().withAnnotation(AMQPFederationConstants.EVENT_TYPE.toString(), (Object)"REQUESTED_ADDRESS_ADDED_EVENT").also().withBody().withValue(eventMap).also().now();
    }

    private static void sendAddresPolicyToRemote(ProtonTestClient peer, FederationReceiveFromAddressPolicy policy) {
        TransformerConfiguration transformerConfig;
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        policyMap.put("policy-name", policy.getPolicyName());
        policyMap.put("auto-delete", policy.isAutoDelete());
        policyMap.put("auto-delete-delay", policy.getAutoDeleteDelay());
        policyMap.put("auto-delete-msg-count", policy.getAutoDeleteMessageCount());
        policyMap.put("max-hops", policy.getMaxHops());
        policyMap.put("enable-divert-bindings", policy.isEnableDivertBindings());
        if (!policy.getIncludes().isEmpty()) {
            policyMap.put("address-includes", new ArrayList(policy.getIncludes()));
        }
        if (!policy.getExcludes().isEmpty()) {
            policyMap.put("address-excludes", new ArrayList(policy.getExcludes()));
        }
        if ((transformerConfig = policy.getTransformerConfiguration()) != null) {
            policyMap.put("transformer-class-name", transformerConfig.getClassName());
            if (transformerConfig.getProperties() != null && !transformerConfig.getProperties().isEmpty()) {
                policyMap.put("transformer-properties-map", transformerConfig.getProperties());
            }
        }
        if (!policy.getProperties().isEmpty()) {
            policyMap.put("policy-properties-map", policy.getProperties());
        }
        peer.remoteTransfer().withDeliveryId(0).withMessageAnnotations().withAnnotation(AMQPFederationConstants.OPERATION_TYPE.toString(), (Object)"ADD_ADDRESS_POLICY").also().withBody().withValue(policyMap).also().now();
    }

    private static void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName) {
        AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, federationName, 1000, 300);
    }

    private static void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, int amqpCredits, int amqpLowCredits) {
        AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, federationName, amqpCredits, amqpLowCredits, false, false);
    }

    private static void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, boolean eventsSender, boolean eventsReceiver) {
        AMQPFederationAddressPolicyTest.scriptFederationConnectToRemote(peer, federationName, 1000, 300, eventsSender, eventsReceiver);
    }

    private static void scriptFederationConnectToRemote(ProtonTestClient peer, String federationName, int amqpCredits, int amqpLowCredits, boolean eventsSender, boolean eventsReceiver) {
        String federationEventsSenderLinkName;
        String federationControlLinkName = "Federation:control:" + UUID.randomUUID().toString();
        HashMap<String, Integer> federationConfiguration = new HashMap<String, Integer>();
        federationConfiguration.put("amqpCredits", amqpCredits);
        federationConfiguration.put("amqpLowCredits", amqpLowCredits);
        HashMap<String, HashMap<String, Integer>> senderProperties = new HashMap<String, HashMap<String, Integer>>();
        senderProperties.put(AMQPFederationConstants.FEDERATION_CONFIGURATION.toString(), federationConfiguration);
        peer.queueClientSaslAnonymousConnect();
        peer.remoteOpen().queue();
        peer.expectOpen();
        peer.remoteBegin().queue();
        peer.expectBegin();
        peer.remoteAttach().ofSender().withInitialDeliveryCount(0L).withName(federationControlLinkName).withPropertiesMap(senderProperties).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString()}).withSenderSettleModeUnsettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
        peer.expectAttach().ofReceiver().withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_CONTROL_LINK.toString());
        peer.expectFlow();
        if (eventsSender) {
            federationEventsSenderLinkName = "Federation:events-sender:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofSender().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeSettled().withReceivervSettlesFirst().withSource().also().withTarget().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.expectAttach().ofReceiver().withName(federationEventsSenderLinkName).withTarget().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
            peer.expectFlow();
        }
        if (eventsReceiver) {
            federationEventsSenderLinkName = "Federation:events-receiver:test:" + UUID.randomUUID().toString();
            peer.remoteAttach().ofReceiver().withName(federationEventsSenderLinkName).withDesiredCapabilities(new String[]{AMQPFederationConstants.FEDERATION_EVENT_LINK.toString()}).withSenderSettleModeSettled().withReceivervSettlesFirst().withTarget().also().withSource().withDynamic(true).withDurabilityOfNone().withExpiryPolicyOnLinkDetach().withLifetimePolicyOfDeleteOnClose().withCapabilities(new String[]{"temporary-topic"}).also().queue();
            peer.remoteFlow().withLinkCredit(10L).queue();
            peer.expectAttach().ofSender().withName(federationEventsSenderLinkName).withSource().withAddress(CoreMatchers.notNullValue()).also().withOfferedCapability(AMQPFederationConstants.FEDERATION_EVENT_LINK.toString());
        }
    }

    public static class ApplicationPropertiesTransformer
    implements Transformer {
        private final Map<String, String> properties = new HashMap<String, String>();

        public void init(Map<String, String> externalProperties) {
            this.properties.putAll(externalProperties);
        }

        public org.apache.activemq.artemis.api.core.Message transform(org.apache.activemq.artemis.api.core.Message message) {
            if (!(message instanceof AMQPMessage)) {
                return message;
            }
            this.properties.forEach((k, v) -> message.putStringProperty(k, v));
            message.reencode();
            return message;
        }
    }

    private class AMQPTestFederationBrokerPlugin
    implements ActiveMQServerAMQPFederationPlugin {
        public final AtomicBoolean started = new AtomicBoolean();
        public final AtomicBoolean stopped = new AtomicBoolean();
        public final AtomicReference<FederationConsumerInfo> beforeCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCreateConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> beforeCloseConsumerCapture = new AtomicReference();
        public final AtomicReference<FederationConsumer> afterCloseConsumerCapture = new AtomicReference();
        public Consumer<FederationConsumerInfo> beforeCreateConsumer = c -> this.beforeCreateConsumerCapture.set((FederationConsumerInfo)c);
        public Consumer<FederationConsumer> afterCreateConsumer = c -> this.afterCreateConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> beforeCloseConsumer = c -> this.beforeCloseConsumerCapture.set((FederationConsumer)c);
        public Consumer<FederationConsumer> afterCloseConsumer = c -> this.afterCloseConsumerCapture.set((FederationConsumer)c);
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> beforeMessageHandled = (c, m) -> {};
        public BiConsumer<FederationConsumer, org.apache.activemq.artemis.api.core.Message> afterMessageHandled = (c, m) -> {};
        public Function<AddressInfo, Boolean> shouldCreateConsumerForAddress = a -> true;
        public Function<org.apache.activemq.artemis.core.server.Queue, Boolean> shouldCreateConsumerForQueue = q -> true;
        public BiFunction<Divert, org.apache.activemq.artemis.core.server.Queue, Boolean> shouldCreateConsumerForDivert = (d, q) -> true;

        private AMQPTestFederationBrokerPlugin() {
        }

        public void federationStarted(Federation federation) throws ActiveMQException {
            this.started.set(true);
        }

        public void federationStopped(Federation federation) throws ActiveMQException {
            this.stopped.set(true);
        }

        public void beforeCreateFederationConsumer(FederationConsumerInfo consumerInfo) throws ActiveMQException {
            this.beforeCreateConsumer.accept(consumerInfo);
        }

        public void afterCreateFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCreateConsumer.accept(consumer);
        }

        public void beforeCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.beforeCloseConsumer.accept(consumer);
        }

        public void afterCloseFederationConsumer(FederationConsumer consumer) throws ActiveMQException {
            this.afterCloseConsumer.accept(consumer);
        }

        public void beforeFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.beforeMessageHandled.accept(consumer, message);
        }

        public void afterFederationConsumerMessageHandled(FederationConsumer consumer, org.apache.activemq.artemis.api.core.Message message) throws ActiveMQException {
            this.afterMessageHandled.accept(consumer, message);
        }

        public boolean shouldCreateFederationConsumerForAddress(AddressInfo address) throws ActiveMQException {
            return this.shouldCreateConsumerForAddress.apply(address);
        }

        public boolean shouldCreateFederationConsumerForQueue(org.apache.activemq.artemis.core.server.Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForQueue.apply(queue);
        }

        public boolean shouldCreateFederationConsumerForDivert(Divert divert, org.apache.activemq.artemis.core.server.Queue queue) throws ActiveMQException {
            return this.shouldCreateConsumerForDivert.apply(divert, queue);
        }
    }
}

