/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerFilterTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ActiveMQServer server;
    private ClientSession session;
    private ClientProducer producer;
    private ClientConsumer consumer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.session = sf.createSession();
        this.session.start();
        this.session.createQueue(QueueConfiguration.of((String)"foo").setRoutingType(RoutingType.ANYCAST));
        this.producer = this.session.createProducer("foo");
        this.consumer = this.session.createConsumer("foo", "animal='giraffe'");
    }

    @Test
    public void testLargeToken() throws Exception {
        StringBuffer token = new StringBuffer();
        token.append("'");
        for (int i = 0; i < 5000; ++i) {
            token.append("a");
        }
        token.append("'");
        this.consumer = this.session.createConsumer("foo", "animal=" + token.toString());
    }

    @Test
    public void testNonMatchingMessagesFollowedByMatchingMessages() throws Exception {
        ClientMessage message = this.session.createMessage(false);
        message.putStringProperty("animal", "hippo");
        this.producer.send((Message)message);
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        message = this.session.createMessage(false);
        message.putStringProperty("animal", "giraffe");
        logger.debug("sending second msg");
        this.producer.send((Message)message);
        ClientMessage received = this.consumer.receiveImmediate();
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"giraffe", (Object)received.getStringProperty("animal"));
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        this.session.close();
    }

    @Test
    public void testNonMatchingMessagesFollowedByMatchingMessagesMany() throws Exception {
        ClientMessage message;
        int i;
        for (i = 0; i < 2000; ++i) {
            message = this.session.createMessage(false);
            message.putStringProperty("animal", "hippo");
            this.producer.send((Message)message);
        }
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        for (i = 0; i < 2000; ++i) {
            message = this.session.createMessage(false);
            message.putStringProperty("animal", "giraffe");
            this.producer.send((Message)message);
        }
        for (i = 0; i < 2000; ++i) {
            ClientMessage received = this.consumer.receiveImmediate();
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)"giraffe", (Object)received.getStringProperty("animal"));
        }
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        this.session.close();
    }

    @Test
    public void testTwoConsumers() throws Exception {
        ClientConsumer consumer2 = this.session.createConsumer("foo", "animal='elephant'");
        ClientMessage message = this.session.createMessage(false);
        message.putStringProperty("animal", "giraffe");
        this.producer.send((Message)message);
        ClientMessage received = this.consumer.receive(10000L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"giraffe", (Object)received.getStringProperty("animal"));
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        message = this.session.createMessage(false);
        message.putStringProperty("animal", "giraffe");
        this.producer.send((Message)message);
        received = this.consumer.receive(10000L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"giraffe", (Object)received.getStringProperty("animal"));
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        message = this.session.createMessage(false);
        message.putStringProperty("animal", "elephant");
        this.producer.send((Message)message);
        received = consumer2.receive(10000L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"elephant", (Object)received.getStringProperty("animal"));
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        message = this.session.createMessage(false);
        message.putStringProperty("animal", "elephant");
        this.producer.send((Message)message);
        received = consumer2.receive(1000L);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)"elephant", (Object)received.getStringProperty("animal"));
        Assertions.assertNull((Object)this.consumer.receiveImmediate());
        Assertions.assertNull((Object)consumer2.receiveImmediate());
        this.session.close();
    }

    @Test
    public void testLinkedListOrder() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.createSessionFactory(locator);
        ClientSession session = sf.createSession();
        session.start();
        ClientProducer producer = session.createProducer("foo");
        ClientConsumer redConsumer = session.createConsumer("foo", "color='red'");
        ClientConsumer anyConsumer = session.createConsumer("foo");
        this.sendMessage(session, producer, "any", "msg1");
        this.sendMessage(session, producer, "any", "msg2");
        this.sendMessage(session, producer, "any", "msg3");
        this.sendMessage(session, producer, "red", "msgRed4");
        this.sendMessage(session, producer, "red", "msgRed5");
        this.readConsumer("anyConsumer", anyConsumer);
        this.readConsumer("anyConsumer", anyConsumer);
        logger.debug("### closing consumer ###");
        anyConsumer.close();
        this.readConsumer("redConsumer", redConsumer);
        this.readConsumer("redConsumer", redConsumer);
        logger.debug("### recreating consumer ###");
        anyConsumer = session.createConsumer("foo");
        session.start();
        this.readConsumer("anyConsumer", anyConsumer);
        session.close();
        sf.close();
        locator.close();
    }

    private void readConsumer(String consumerName, ClientConsumer consumer) throws Exception {
        ClientMessage message = consumer.receive(5000L);
        Assertions.assertNotNull((Object)message);
        logger.debug("consumer = {} message, color={}, msg = {}", new Object[]{consumerName, message.getStringProperty("color"), message.getStringProperty("value")});
        message.acknowledge();
    }

    private void sendMessage(ClientSession session, ClientProducer producer, String color, String msg) throws Exception {
        ClientMessage anyMessage = session.createMessage(true);
        anyMessage.putStringProperty("color", color);
        anyMessage.putStringProperty("value", msg);
        producer.send((Message)anyMessage);
        session.commit();
    }
}

