/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.tests.util.CountDownSessionFailureListener;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FailBackManualTest
extends FailoverTestBase {
    private ServerLocatorInternal locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    @Test
    public void testNoAutoFailback() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)sf, true);
        CountDownSessionFailureListener listener = new CountDownSessionFailureListener(1, session);
        session.addFailureListener((SessionFailureListener)listener);
        this.backupServer.stop();
        this.primaryServer.crash(new ClientSession[0]);
        this.backupServer.start();
        Assertions.assertTrue((boolean)listener.getLatch().await(5L, TimeUnit.SECONDS));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        session.removeFailureListener((SessionFailureListener)listener);
        Thread t = new Thread(new ServerStarter(this.primaryServer));
        t.start();
        FailBackManualTest.waitForRemoteBackup((ClientSessionFactory)sf, 10, false, this.backupServer.getServer());
        Assertions.assertTrue((boolean)this.backupServer.isStarted());
        this.backupServer.crash(new ClientSession[0]);
        this.waitForServerToStart(this.primaryServer.getServer());
        Assertions.assertTrue((boolean)this.primaryServer.isStarted());
        sf.close();
        Assertions.assertEquals((int)0, (int)sf.numSessions());
        Assertions.assertEquals((int)0, (int)sf.numConnections());
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setAllowFailBack(false)).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailBackManualTest.basicClusterConnectionConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailBackManualTest.basicClusterConnectionConfig(primaryConnector.getName(), backupConnector.getName()));
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMAcceptor(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return TransportConfigurationUtils.getInVMConnector(live);
    }

    private ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS).setDurable(Boolean.valueOf(false)));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assertions.assertEquals((Object)i, (Object)message2.getObjectProperty(SimpleString.of((String)"count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        Assertions.assertNull((Object)message3);
        return session;
    }

    @Override
    protected void setBody(int i, ClientMessage message) {
        message.getBodyBuffer().writeString("message" + i);
    }

    static class ServerStarter
    implements Runnable {
        private final TestableServer server;

        ServerStarter(TestableServer server) {
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

