/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.server;

import jakarta.jms.Destination;
import jakarta.jms.JMSContext;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AddressQueryTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testAddressQueryDefaultsOnStaticAddress() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.addAddressInfo(new AddressInfo(addressName));
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        Assertions.assertTrue((boolean)addressQueryResult.isExists());
        Assertions.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        Assertions.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        Assertions.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        Assertions.assertEquals((int)-1, (int)addressQueryResult.getDefaultMaxConsumers());
        Assertions.assertFalse((boolean)addressQueryResult.isAutoCreated());
        Assertions.assertFalse((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryOnStaticAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.of((String)UUID.randomUUID().toString()));
        this.server.addAddressInfo(new AddressInfo(fqqn));
        Assertions.assertEquals((Object)addressName, (Object)this.server.addressQuery(addressName).getName());
        Assertions.assertEquals((Object)addressName, (Object)this.server.addressQuery(fqqn).getName());
    }

    @Test
    public void testAddressQueryNonExistentAddress() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        Assertions.assertFalse((boolean)addressQueryResult.isExists());
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
    }

    @Test
    public void testAddressQueryNonExistentAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.of((String)UUID.randomUUID().toString()));
        AddressQueryResult addressQueryResult = this.server.addressQuery(fqqn);
        Assertions.assertFalse((boolean)addressQueryResult.isExists());
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
    }

    @Test
    public void testAddressQueryNonDefaultsOnStaticAddress() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(false)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        this.server.addAddressInfo(new AddressInfo(addressName).addRoutingType(RoutingType.ANYCAST));
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        Assertions.assertTrue((boolean)addressQueryResult.isExists());
        Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        Assertions.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        Assertions.assertFalse((boolean)addressQueryResult.isAutoCreateAddresses());
        Assertions.assertEquals((int)1, (int)addressQueryResult.getDefaultMaxConsumers());
        Assertions.assertFalse((boolean)addressQueryResult.isAutoCreated());
        Assertions.assertTrue((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryDefaultsOnAutoCreatedAddress() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings());
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(addressName.toString()), c.createMessage());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        Assertions.assertTrue((boolean)addressQueryResult.isExists());
        Assertions.assertFalse((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.ANYCAST));
        Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        Assertions.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        Assertions.assertEquals((int)-1, (int)addressQueryResult.getDefaultMaxConsumers());
        Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
        Assertions.assertFalse((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }

    @Test
    public void testAddressQueryOnAutoCreatedAddressWithFQQN() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        SimpleString fqqn = addressName.concat("::").concat(SimpleString.of((String)UUID.randomUUID().toString()));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(fqqn.toString()), c.createMessage());
        Assertions.assertEquals((Object)addressName, (Object)this.server.addressQuery(addressName).getName());
        Assertions.assertEquals((Object)addressName, (Object)this.server.addressQuery(fqqn).getName());
    }

    @Test
    public void testAddressQueryNonDefaultsOnAutoCreatedAddress() throws Exception {
        SimpleString addressName = SimpleString.of((String)UUID.randomUUID().toString());
        this.server.getAddressSettingsRepository().addMatch(addressName.toString(), (Object)new AddressSettings().setAutoCreateAddresses(Boolean.valueOf(true)).setDefaultMaxConsumers(Integer.valueOf(1)).setDefaultPurgeOnNoConsumers(Boolean.valueOf(true)));
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("vm://0");
        JMSContext c = cf.createContext();
        c.createProducer().send((Destination)c.createTopic(addressName.toString()), c.createMessage());
        AddressQueryResult addressQueryResult = this.server.addressQuery(addressName);
        Assertions.assertTrue((boolean)addressQueryResult.isExists());
        Assertions.assertTrue((boolean)addressQueryResult.getRoutingTypes().contains(RoutingType.MULTICAST));
        Assertions.assertEquals((Object)addressName, (Object)addressQueryResult.getName());
        Assertions.assertTrue((boolean)addressQueryResult.isAutoCreateAddresses());
        Assertions.assertEquals((int)1, (int)addressQueryResult.getDefaultMaxConsumers());
        Assertions.assertTrue((boolean)addressQueryResult.isAutoCreated());
        Assertions.assertTrue((boolean)addressQueryResult.isDefaultPurgeOnNoConsumers());
    }
}

