/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl;

import com.sun.tools.corba.se.idl.Arguments;
import com.sun.tools.corba.se.idl.AttributeEntry;
import com.sun.tools.corba.se.idl.AttributeGen;
import com.sun.tools.corba.se.idl.ConstEntry;
import com.sun.tools.corba.se.idl.ConstGen;
import com.sun.tools.corba.se.idl.DefaultSymtabFactory;
import com.sun.tools.corba.se.idl.EnumEntry;
import com.sun.tools.corba.se.idl.EnumGen;
import com.sun.tools.corba.se.idl.ExceptionEntry;
import com.sun.tools.corba.se.idl.ExceptionGen;
import com.sun.tools.corba.se.idl.Factories;
import com.sun.tools.corba.se.idl.ForwardEntry;
import com.sun.tools.corba.se.idl.ForwardGen;
import com.sun.tools.corba.se.idl.ForwardValueEntry;
import com.sun.tools.corba.se.idl.ForwardValueGen;
import com.sun.tools.corba.se.idl.GenFactory;
import com.sun.tools.corba.se.idl.IncludeEntry;
import com.sun.tools.corba.se.idl.IncludeGen;
import com.sun.tools.corba.se.idl.InterfaceEntry;
import com.sun.tools.corba.se.idl.InterfaceGen;
import com.sun.tools.corba.se.idl.InvalidArgument;
import com.sun.tools.corba.se.idl.MethodEntry;
import com.sun.tools.corba.se.idl.MethodGen;
import com.sun.tools.corba.se.idl.ModuleEntry;
import com.sun.tools.corba.se.idl.ModuleGen;
import com.sun.tools.corba.se.idl.NativeEntry;
import com.sun.tools.corba.se.idl.NativeGen;
import com.sun.tools.corba.se.idl.NoPragma;
import com.sun.tools.corba.se.idl.Noop;
import com.sun.tools.corba.se.idl.ParameterEntry;
import com.sun.tools.corba.se.idl.ParameterGen;
import com.sun.tools.corba.se.idl.ParseException;
import com.sun.tools.corba.se.idl.Parser;
import com.sun.tools.corba.se.idl.PragmaEntry;
import com.sun.tools.corba.se.idl.PragmaGen;
import com.sun.tools.corba.se.idl.PragmaHandler;
import com.sun.tools.corba.se.idl.Preprocessor;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.PrimitiveGen;
import com.sun.tools.corba.se.idl.SequenceEntry;
import com.sun.tools.corba.se.idl.SequenceGen;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.StringGen;
import com.sun.tools.corba.se.idl.StructEntry;
import com.sun.tools.corba.se.idl.StructGen;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.SymtabFactory;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.TypedefGen;
import com.sun.tools.corba.se.idl.UnionEntry;
import com.sun.tools.corba.se.idl.UnionGen;
import com.sun.tools.corba.se.idl.Util;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.ValueBoxGen;
import com.sun.tools.corba.se.idl.ValueEntry;
import com.sun.tools.corba.se.idl.ValueGen;
import com.sun.tools.corba.se.idl.constExpr.DefaultExprFactory;
import com.sun.tools.corba.se.idl.constExpr.ExprFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class Compile {
    public Arguments arguments = null;
    protected Hashtable overrideNames = new Hashtable();
    protected Hashtable symbolTable = new Hashtable();
    protected Vector includes = new Vector();
    protected Vector includeEntries = new Vector();
    static Noop noop = new Noop();
    private GenFactory genFactory = null;
    private SymtabFactory symtabFactory = null;
    private ExprFactory exprFactory = null;
    private Parser parser = null;
    Preprocessor preprocessor = new Preprocessor();
    private NoPragma noPragma = new NoPragma();
    private Enumeration emitList = null;
    private String[] keywords = null;

    public Compile() {
        this.noPragma.init(this.preprocessor);
        this.preprocessor.registerPragma(this.noPragma);
        ParseException.detected = false;
        SymtabEntry.includeStack = new Stack();
        SymtabEntry.setEmit = true;
        Parser.repIDStack = new Stack();
    }

    public static void main(String[] args) {
        new Compile().start(args);
    }

    protected Factories factories() {
        return new Factories();
    }

    protected void registerPragma(PragmaHandler handler) {
        handler.init(this.preprocessor);
        this.preprocessor.registerPragma(handler);
    }

    protected void init(String[] args) throws InvalidArgument {
        this.initFactories();
        this.arguments.parseArgs(args);
        this.initGenerators();
        this.parser = new Parser(this.preprocessor, this.arguments, this.overrideNames, this.symbolTable, this.symtabFactory, this.exprFactory, this.keywords);
        this.preprocessor.init(this.parser);
        this.parser.includes = this.includes;
        this.parser.includeEntries = this.includeEntries;
    }

    protected Enumeration parse() throws IOException {
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parsing", this.arguments.file));
        }
        this.parser.parse(this.arguments.file);
        if (!ParseException.detected) {
            this.parser.forwardEntryCheck();
        }
        if (this.arguments.verbose) {
            System.out.println(Util.getMessage("Compile.parseDone", this.arguments.file));
        }
        if (ParseException.detected) {
            this.symbolTable = null;
            this.emitList = null;
        } else {
            this.symbolTable = Parser.symbolTable;
            this.emitList = this.parser.emitList.elements();
        }
        return this.emitList;
    }

    protected void generate() throws IOException {
        this.emitList = ParseException.detected ? null : this.parser.emitList.elements();
        if (this.emitList != null) {
            if (this.arguments.verbose) {
                System.out.println();
            }
            while (this.emitList.hasMoreElements()) {
                SymtabEntry entry = (SymtabEntry)this.emitList.nextElement();
                if (this.arguments.verbose && !(entry.generator() instanceof Noop)) {
                    if (entry.module().equals("")) {
                        System.out.println(Util.getMessage("Compile.generating", entry.name()));
                    } else {
                        System.out.println(Util.getMessage("Compile.generating", entry.module() + "/" + entry.name()));
                    }
                }
                entry.generate(this.symbolTable, null);
                if (!this.arguments.verbose || entry.generator() instanceof Noop) continue;
                if (entry.module().equals("")) {
                    System.out.println(Util.getMessage("Compile.genDone", entry.name()));
                    continue;
                }
                System.out.println(Util.getMessage("Compile.genDone", entry.module() + "/" + entry.name()));
            }
        }
    }

    public void start(String[] args) {
        try {
            this.init(args);
            if (this.arguments.versionRequest) {
                this.displayVersion();
            } else {
                this.parse();
                this.generate();
            }
        }
        catch (InvalidArgument e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void initFactories() {
        Arguments tmpArgs;
        Factories factories = this.factories();
        if (factories == null) {
            factories = new Factories();
        }
        this.arguments = (tmpArgs = factories.arguments()) == null ? new Arguments() : tmpArgs;
        SymtabFactory tmpSTF = factories.symtabFactory();
        this.symtabFactory = tmpSTF == null ? new DefaultSymtabFactory() : tmpSTF;
        ExprFactory tmpExpF = factories.exprFactory();
        this.exprFactory = tmpExpF == null ? new DefaultExprFactory() : tmpExpF;
        GenFactory tmpGenF = factories.genFactory();
        this.genFactory = tmpGenF == null ? noop : tmpGenF;
        this.keywords = factories.languageKeywords();
        if (this.keywords == null) {
            this.keywords = new String[0];
        }
    }

    private void initGenerators() {
        AttributeGen agen = this.genFactory.createAttributeGen();
        AttributeEntry.attributeGen = agen == null ? noop : agen;
        ConstGen cgen = this.genFactory.createConstGen();
        ConstEntry.constGen = cgen == null ? noop : cgen;
        EnumGen egen = this.genFactory.createEnumGen();
        EnumEntry.enumGen = egen == null ? noop : egen;
        ExceptionGen exgen = this.genFactory.createExceptionGen();
        ExceptionEntry.exceptionGen = exgen == null ? noop : exgen;
        ForwardGen fgen = this.genFactory.createForwardGen();
        ForwardEntry.forwardGen = fgen == null ? noop : fgen;
        ForwardValueGen fvgen = this.genFactory.createForwardValueGen();
        ForwardValueEntry.forwardValueGen = fvgen == null ? noop : fvgen;
        IncludeGen ingen = this.genFactory.createIncludeGen();
        IncludeEntry.includeGen = ingen == null ? noop : ingen;
        InterfaceGen igen = this.genFactory.createInterfaceGen();
        InterfaceEntry.interfaceGen = igen == null ? noop : igen;
        ValueGen vgen = this.genFactory.createValueGen();
        ValueEntry.valueGen = vgen == null ? noop : vgen;
        ValueBoxGen vbgen = this.genFactory.createValueBoxGen();
        ValueBoxEntry.valueBoxGen = vbgen == null ? noop : vbgen;
        MethodGen mgen = this.genFactory.createMethodGen();
        MethodEntry.methodGen = mgen == null ? noop : mgen;
        ModuleGen modgen = this.genFactory.createModuleGen();
        ModuleEntry.moduleGen = modgen == null ? noop : modgen;
        NativeGen ngen = this.genFactory.createNativeGen();
        NativeEntry.nativeGen = ngen == null ? noop : ngen;
        ParameterGen pgen = this.genFactory.createParameterGen();
        ParameterEntry.parameterGen = pgen == null ? noop : pgen;
        PragmaGen prgen = this.genFactory.createPragmaGen();
        PragmaEntry.pragmaGen = prgen == null ? noop : prgen;
        PrimitiveGen primgen = this.genFactory.createPrimitiveGen();
        PrimitiveEntry.primitiveGen = primgen == null ? noop : primgen;
        SequenceGen seqgen = this.genFactory.createSequenceGen();
        SequenceEntry.sequenceGen = seqgen == null ? noop : seqgen;
        StringGen strgen = this.genFactory.createStringGen();
        StringEntry.stringGen = strgen == null ? noop : strgen;
        StructGen sgen = this.genFactory.createStructGen();
        StructEntry.structGen = sgen == null ? noop : sgen;
        TypedefGen tgen = this.genFactory.createTypedefGen();
        TypedefEntry.typedefGen = tgen == null ? noop : tgen;
        UnionGen ugen = this.genFactory.createUnionGen();
        UnionEntry.unionGen = ugen == null ? noop : ugen;
    }

    protected void displayVersion() {
        String message = Util.getMessage("Version.product", Util.getMessage("Version.number"));
        System.out.println(message);
    }
}

