/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.processors;

import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.DeploymentUnit;

public final class VertxDeploymentAttachment {
    private static final AttachmentKey<Boolean> MARKER_ATTACHMENT_KEY = AttachmentKey.create(Boolean.class);

    private VertxDeploymentAttachment() {
    }

    public static void attachVertxDeployments(DeploymentUnit deployment) {
        VertxDeploymentAttachment.getRootDeploymentUnit(deployment).putAttachment(MARKER_ATTACHMENT_KEY, (Object)true);
    }

    public static boolean isVertxDeployment(DeploymentUnit deploymentUnit) {
        Boolean marker = (Boolean)VertxDeploymentAttachment.getRootDeploymentUnit(deploymentUnit).getAttachment(MARKER_ATTACHMENT_KEY);
        return marker != null && marker != false;
    }

    public static void removeVertxDeploymentsMeta(DeploymentUnit deploymentUnit) {
        VertxDeploymentAttachment.getRootDeploymentUnit(deploymentUnit).removeAttachment(MARKER_ATTACHMENT_KEY);
    }

    public static DeploymentUnit getRootDeploymentUnit(DeploymentUnit deploymentUnit) {
        if (deploymentUnit.getParent() == null) {
            return deploymentUnit;
        }
        return deploymentUnit.getParent();
    }
}

