/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.ee.component.EEClassIntrospector;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.injection.InjectionTargets;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.as.weld.util.Utils;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.injection.producer.BasicInjectionTarget;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;

public class WeldClassIntrospector
implements EEClassIntrospector,
Service {
    private static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"weld", "weldClassIntrospector"});
    private final Consumer<EEClassIntrospector> eeClassIntrospectorConsumer;
    private final Supplier<BeanManager> beanManagerSupplier;
    private final ConcurrentMap<Class<?>, InjectionTarget<?>> injectionTargets = new ConcurrentHashMap();

    private WeldClassIntrospector(Consumer<EEClassIntrospector> eeClassIntrospectorConsumer, Supplier<BeanManager> beanManagerSupplier) {
        this.eeClassIntrospectorConsumer = eeClassIntrospectorConsumer;
        this.beanManagerSupplier = beanManagerSupplier;
    }

    public static void install(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget) {
        ServiceName sn = WeldClassIntrospector.serviceName(deploymentUnit);
        ServiceBuilder sb = serviceTarget.addService(sn);
        Consumer eeClassIntrospectorConsumer = sb.provides(new ServiceName[]{sn});
        Supplier beanManagerSupplier = sb.requires(BeanManagerService.serviceName(deploymentUnit));
        sb.requires(Utils.getRootDeploymentUnit(deploymentUnit).getServiceName().append(WeldStartService.SERVICE_NAME));
        sb.setInstance((Service)new WeldClassIntrospector(eeClassIntrospectorConsumer, beanManagerSupplier));
        sb.install();
    }

    public static ServiceName serviceName(DeploymentUnit deploymentUnit) {
        return deploymentUnit.getServiceName().append(SERVICE_NAME);
    }

    public ManagedReferenceFactory createFactory(Class<?> clazz) {
        final BeanManager beanManager = this.beanManagerSupplier.get();
        final InjectionTarget injectionTarget = this.getInjectionTarget(clazz);
        return new ManagedReferenceFactory(){

            public ManagedReference getReference() {
                Object instance;
                BasicInjectionTarget target;
                CreationalContext context = beanManager.createCreationalContext(null);
                BasicInjectionTarget basicInjectionTarget = target = injectionTarget instanceof BasicInjectionTarget ? (BasicInjectionTarget)injectionTarget : null;
                if (target != null && target.getBean() != null) {
                    instance = beanManager.getReference(target.getBean(), target.getAnnotatedType().getBaseType(), context);
                } else {
                    instance = injectionTarget.produce(context);
                    injectionTarget.inject(instance, context);
                    injectionTarget.postConstruct(instance);
                }
                return new WeldManagedReference(injectionTarget, context, instance);
            }
        };
    }

    private InjectionTarget getInjectionTarget(Class<?> clazz) {
        WeldInjectionTarget newTarget;
        InjectionTarget target = (InjectionTarget)this.injectionTargets.get(clazz);
        if (target != null) {
            return target;
        }
        BeanManagerImpl beanManager = BeanManagerProxy.unwrap((BeanManager)this.beanManagerSupplier.get());
        Bean bean = null;
        HashSet beans = new HashSet(beanManager.getBeans(clazz, new Annotation[]{Any.Literal.INSTANCE}));
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            Bean b = (Bean)it.next();
            if (b.getBeanClass() == clazz) continue;
            it.remove();
        }
        if (beans.size() == 1) {
            bean = (Bean)beans.iterator().next();
        }
        if ((target = (InjectionTarget)this.injectionTargets.putIfAbsent(clazz, (InjectionTarget<?>)(newTarget = InjectionTargets.createInjectionTarget(clazz, bean, beanManager, true)))) == null) {
            return newTarget;
        }
        return target;
    }

    public ManagedReference createInstance(Object instance) {
        return this.getReference(instance, true);
    }

    public ManagedReference getInstance(Object instance) {
        return this.getReference(instance, false);
    }

    private ManagedReference getReference(Object instance, boolean newInstance) {
        BeanManager beanManager = this.beanManagerSupplier.get();
        InjectionTarget injectionTarget = this.getInjectionTarget(instance.getClass());
        CreationalContext context = beanManager.createCreationalContext(null);
        if (newInstance) {
            injectionTarget.inject(instance, context);
            injectionTarget.postConstruct(instance);
        }
        return new WeldManagedReference(injectionTarget, context, instance);
    }

    public void start(StartContext startContext) throws StartException {
        this.eeClassIntrospectorConsumer.accept(this);
    }

    public void stop(StopContext stopContext) {
        this.injectionTargets.clear();
    }

    private static class WeldManagedReference
    implements ManagedReference {
        private final InjectionTarget injectionTarget;
        private final CreationalContext ctx;
        private final Object instance;

        public WeldManagedReference(InjectionTarget injectionTarget, CreationalContext ctx, Object instance) {
            this.injectionTarget = injectionTarget;
            this.ctx = ctx;
            this.instance = instance;
        }

        public void release() {
            try {
                this.injectionTarget.preDestroy(this.instance);
            }
            finally {
                this.ctx.release();
            }
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

