/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.RealmSecurityProviderService;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.ConnectedChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.SslConnection;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class RemotingHttpUpgradeService
implements Service<RemotingHttpUpgradeService> {
    public static final String JBOSS_REMOTING = "jboss-remoting";
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"remoting ", "remoting-http-upgrade-service"});
    private final String httpConnectorName;
    private final String endpointName;
    private final InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    private final InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private final InjectedValue<Endpoint> injectedEndpoint = new InjectedValue();
    private final InjectedValue<RemotingSecurityProvider> securityProviderValue = new InjectedValue();
    private final OptionMap connectorPropertiesOptionMap;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public RemotingHttpUpgradeService(String httpConnectorName, String endpointName, OptionMap connectorPropertiesOptionMap) {
        this.httpConnectorName = httpConnectorName;
        this.endpointName = endpointName;
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public static void installServices(ServiceTarget serviceTarget, String remotingConnectorName, String httpConnectorName, ServiceName endpointName, OptionMap connectorPropertiesOptionMap, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        RemotingHttpUpgradeService service = new RemotingHttpUpgradeService(httpConnectorName, endpointName.getSimpleName(), connectorPropertiesOptionMap);
        ServiceName securityProviderName = RealmSecurityProviderService.createName(remotingConnectorName);
        ServiceBuilder builder = serviceTarget.addService(UPGRADE_SERVICE_NAME.append(new String[]{remotingConnectorName}), (Service)service).setInitialMode(ServiceController.Mode.PASSIVE).addDependency(HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}), ChannelUpgradeHandler.class, service.injectedRegistry).addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry).addDependency(endpointName, Endpoint.class, service.injectedEndpoint).addDependency(securityProviderName, RemotingSecurityProvider.class, service.securityProviderValue);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = (Endpoint)this.injectedEndpoint.getValue();
        RemotingSecurityProvider rsp = (RemotingSecurityProvider)this.securityProviderValue.getValue();
        ServerAuthenticationProvider sap = rsp.getServerAuthenticationProvider();
        OptionMap.Builder builder = OptionMap.builder();
        builder.addAll(rsp.getOptionMap());
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, this.endpointName);
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        RemotingConnectorBindingInfoService.install(context.getChildTarget(), context.getController().getName().getSimpleName(), (SocketBinding)listenerInfo.getContextInformation("socket-binding"), listenerInfo.getProtocol().equals("https") ? "https-remoting" : "http-remoting");
        if (this.connectorPropertiesOptionMap != null) {
            builder.addAll(this.connectorPropertiesOptionMap);
        }
        OptionMap resultingMap = builder.getMap();
        try {
            ExternalConnectionProvider provider = (ExternalConnectionProvider)endpoint.getConnectionProviderInterface("http-remoting", ExternalConnectionProvider.class);
            final ExternalConnectionProvider.ConnectionAdaptor adaptor = provider.createConnectionAdaptor(resultingMap, sap);
            ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol(JBOSS_REMOTING, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    if (channel instanceof SslConnection) {
                        adaptor.adapt((ConnectedStreamChannel)new AssembledConnectedSslStreamChannel((SslChannel)((SslConnection)channel), (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel()));
                    } else {
                        adaptor.adapt((ConnectedStreamChannel)new AssembledConnectedStreamChannel((ConnectedChannel)channel, (StreamSourceChannel)channel.getSourceChannel(), (StreamSinkChannel)channel.getSinkChannel()));
                    }
                }
            }, (HttpUpgradeHandshake)new RemotingUpgradeHanshake());
        }
        catch (UnknownURISchemeException e) {
            throw new StartException((Throwable)e);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpConnectorName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol(JBOSS_REMOTING);
    }

    public synchronized RemotingHttpUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static final class RemotingUpgradeHanshake
    implements HttpUpgradeHandshake {
        public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
        public static final HttpString SEC_JBOSS_REMOTING_KEY = new HttpString("Sec-JbossRemoting-Key");
        public static final HttpString SEC_JBOSS_REMOTING_ACCEPT = new HttpString("Sec-JbossRemoting-Accept");

        private RemotingUpgradeHanshake() {
        }

        public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
            String key = exchange.getRequestHeaders().getFirst(SEC_JBOSS_REMOTING_KEY);
            if (key == null) {
                throw RemotingMessages.MESSAGES.upgradeRequestMissingKey();
            }
            exchange.getResponseHeaders().put(SEC_JBOSS_REMOTING_ACCEPT, this.createExpectedResponse(key));
            return true;
        }

        protected String createExpectedResponse(String secKey) throws IOException {
            try {
                String concat = secKey + MAGIC_NUMBER;
                MessageDigest digest = MessageDigest.getInstance("SHA1");
                digest.update(concat.getBytes("UTF-8"));
                byte[] bytes = digest.digest();
                return FlexBase64.encodeString(bytes, false);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e);
            }
        }

        private static class FlexBase64 {
            private static final byte[] ENCODING_TABLE;
            private static final byte[] DECODING_TABLE;
            private static final Constructor<String> STRING_CONSTRUCTOR;

            private FlexBase64() {
            }

            public static String encodeString(byte[] source, boolean wrap) {
                return FlexBase64.encodeString(source, 0, source.length, wrap);
            }

            private static String encodeString(byte[] source, int pos, int limit, boolean wrap) {
                int olimit;
                int remainder = (olimit = limit - pos) % 3;
                olimit = (olimit + (remainder == 0 ? 0 : 3 - remainder)) / 3 * 4;
                char[] target = new char[olimit += wrap ? olimit / 76 * 2 + 2 : 0];
                int opos = 0;
                int last = 0;
                int count = 0;
                int state = 0;
                byte[] ENCODING_TABLE = FlexBase64.ENCODING_TABLE;
                while (limit > pos) {
                    int b = source[pos++] & 0xFF;
                    target[opos++] = (char)ENCODING_TABLE[b >>> 2];
                    last = (b & 3) << 4;
                    if (pos >= limit) {
                        state = 1;
                        break;
                    }
                    b = source[pos++] & 0xFF;
                    target[opos++] = (char)ENCODING_TABLE[last | b >>> 4];
                    last = (b & 0xF) << 2;
                    if (pos >= limit) {
                        state = 2;
                        break;
                    }
                    b = source[pos++] & 0xFF;
                    target[opos++] = (char)ENCODING_TABLE[last | b >>> 6];
                    target[opos++] = (char)ENCODING_TABLE[b & 0x3F];
                    if (!wrap || (count += 4) < 76) continue;
                    count = 0;
                    target[opos++] = 13;
                    target[opos++] = 10;
                }
                FlexBase64.complete(target, opos, state, last, wrap);
                try {
                    if (STRING_CONSTRUCTOR != null) {
                        return STRING_CONSTRUCTOR.newInstance(target, Boolean.TRUE);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                return new String(target);
            }

            private static int complete(char[] target, int pos, int state, int last, boolean wrap) {
                if (state > 0) {
                    target[pos++] = (char)ENCODING_TABLE[last];
                    for (int i = state; i < 3; ++i) {
                        target[pos++] = 61;
                    }
                }
                if (wrap) {
                    target[pos++] = 13;
                    target[pos++] = 10;
                }
                return pos;
            }

            static {
                DECODING_TABLE = new byte[80];
                try {
                    ENCODING_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes("ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException();
                }
                for (int i = 0; i < ENCODING_TABLE.length; ++i) {
                    int v = (ENCODING_TABLE[i] & 0xFF) - 43;
                    FlexBase64.DECODING_TABLE[v] = (byte)(i + 1);
                }
                Constructor c = null;
                try {
                    PrivilegedExceptionAction<Constructor<String>> runnable = new PrivilegedExceptionAction<Constructor<String>>(){

                        @Override
                        public Constructor<String> run() throws Exception {
                            Constructor<String> c = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
                            c.setAccessible(true);
                            return c;
                        }
                    };
                    c = System.getSecurityManager() != null ? AccessController.doPrivileged(runnable) : (Constructor)runnable.run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                STRING_CONSTRUCTOR = c;
            }
        }
    }
}

