/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.PersistentResourceXMLDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemoteOutboundConnectionResourceDefinition;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class RemotingSubsystem20Parser
extends RemotingSubsystem11Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    static final RemotingSubsystem20Parser INSTANCE = new RemotingSubsystem20Parser();
    static final PersistentResourceXMLDescription ENDPOINT_PARSER = PersistentResourceXMLDescription.builder((PersistentResourceDefinition)RemotingEndpointResource.INSTANCE).addAttributes(new AttributeDefinition[]{RemotingEndpointResource.WORKER, RemotingEndpointResource.SEND_BUFFER_SIZE, RemotingEndpointResource.RECEIVE_BUFFER_SIZE, RemotingEndpointResource.BUFFER_REGION_SIZE, RemotingEndpointResource.TRANSMIT_WINDOW_SIZE, RemotingEndpointResource.RECEIVE_WINDOW_SIZE, RemotingEndpointResource.MAX_OUTBOUND_CHANNELS, RemotingEndpointResource.MAX_INBOUND_CHANNELS, RemotingEndpointResource.AUTHORIZE_ID, RemotingEndpointResource.AUTHORIZE_ID, RemotingEndpointResource.AUTH_REALM, RemotingEndpointResource.AUTHENTICATION_RETRIES, RemotingEndpointResource.MAX_OUTBOUND_MESSAGES, RemotingEndpointResource.MAX_INBOUND_MESSAGES, RemotingEndpointResource.HEARTBEAT_INTERVAL, RemotingEndpointResource.MAX_INBOUND_MESSAGE_SIZE, RemotingEndpointResource.MAX_OUTBOUND_MESSAGE_SIZE, RemotingEndpointResource.SERVER_NAME, RemotingEndpointResource.SASL_PROTOCOL}).build();

    RemotingSubsystem20Parser() {
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((String)"subsystem", (String)"remoting");
        ModelNode subsystem = Util.createAddOperation((PathAddress)address);
        list.add(subsystem);
        ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[0]);
        boolean foundEndpoint = false;
        boolean doneWorkerThreadPool = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WORKER_THREAD_POOL: {
                    if (doneWorkerThreadPool) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.WORKER_THREAD_POOL.getLocalName());
                    }
                    if (foundEndpoint) {
                        throw RemotingSubsystem20Parser.workerThreadPoolEndpointChoiceRequired(reader);
                    }
                    doneWorkerThreadPool = true;
                    this.parseWorkerThreadPool(reader, subsystem);
                    continue block7;
                }
                case ENDPOINT: {
                    if (doneWorkerThreadPool) {
                        throw RemotingSubsystem20Parser.workerThreadPoolEndpointChoiceRequired(reader);
                    }
                    ENDPOINT_PARSER.parse(reader, PathAddress.pathAddress((PathAddress)address, (PathElement[])new PathElement[0]), list);
                    foundEndpoint = true;
                    continue block7;
                }
                case CONNECTOR: {
                    this.parseConnector(reader, address.toModelNode(), list);
                    continue block7;
                }
                case HTTP_CONNECTOR: {
                    this.parseHttpConnector(reader, address.toModelNode(), list);
                    continue block7;
                }
                case OUTBOUND_CONNECTIONS: {
                    this.parseOutboundConnections(reader, address.toModelNode(), list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static XMLStreamException workerThreadPoolEndpointChoiceRequired(XMLExtendedStreamReader reader) {
        return new XMLStreamException(RemotingMessages.MESSAGES.workerThreadsEndpointConfigurationChoiceRequired(Element.WORKER_THREAD_POOL.getLocalName(), Element.ENDPOINT.getLocalName()), reader.getLocation());
    }

    @Override
    void parseRemoteOutboundConnection(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> operations) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.OUTBOUND_SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        String name = null;
        ModelNode addOperation = Util.createAddOperation();
        block10: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block10;
                }
                case OUTBOUND_SOCKET_BINDING_REF: {
                    RemoteOutboundConnectionResourceDefinition.OUTBOUND_SOCKET_BINDING_REF.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case USERNAME: {
                    RemoteOutboundConnectionResourceDefinition.USERNAME.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case SECURITY_REALM: {
                    RemoteOutboundConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case PROTOCOL: {
                    RemoteOutboundConnectionResourceDefinition.PROTOCOL.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress address = PathAddress.pathAddress((PathAddress)PathAddress.pathAddress((ModelNode)parentAddress), (PathElement[])new PathElement[]{PathElement.pathElement((String)"remote-outbound-connection", name)});
        addOperation.get("address").set(address.toModelNode());
        operations.add(addOperation);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, address.toModelNode(), operations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void parseHttpConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String securityRealm = null;
        String connectorRef = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.CONNECTOR_REF);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block5;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block5;
                }
                case CONNECTOR_REF: {
                    connectorRef = value;
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        assert (connectorRef != null);
        ModelNode connector = new ModelNode();
        connector.get("operation").set("add");
        connector.get("address").set(address).add("http-connector", name);
        connector.get("connector-ref").set(connectorRef);
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        list.add(connector);
        this.parseConnectorNestledElements(reader, list, connector);
    }

    private void parseConnectorNestledElements(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode connector) throws XMLStreamException {
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block5;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block5;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

