/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.component.ServiceComponentInstantiator;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class CreateDestroyService
extends AbstractService {
    private final Method createMethod;
    private final Method destroyMethod;
    private final ServiceComponentInstantiator componentInstantiator;
    private ManagedReference managedReference;

    CreateDestroyService(Object mBeanInstance, Method createMethod, Method destroyMethod, ServiceComponentInstantiator componentInstantiator, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader) {
        super(mBeanInstance, setupActions, mbeanContextClassLoader);
        this.createMethod = createMethod;
        this.destroyMethod = destroyMethod;
        this.componentInstantiator = componentInstantiator;
    }

    public void start(StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Creating Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.createMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            throw new StartException(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("create()"), (Throwable)e);
        }
        if (this.componentInstantiator != null) {
            this.managedReference = this.componentInstantiator.initializeInstance(this.getValue());
        }
    }

    public void stop(StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Destroying Service: %s", context.getController().getName());
        }
        if (this.managedReference != null) {
            this.managedReference.release();
        }
        try {
            this.invokeLifecycleMethod(this.destroyMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            SarLogger.ROOT_LOGGER.error(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("create()"), e);
        }
    }
}

