/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.AbstractService;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.service.LifecycleContext;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class StartStopService
extends AbstractService {
    private final Method startMethod;
    private final Method stopMethod;

    StartStopService(Object mBeanInstance, Method startMethod, Method stopMethod, List<SetupAction> setupActions, ClassLoader mbeanContextClassLoader) {
        super(mBeanInstance, setupActions, mbeanContextClassLoader);
        this.startMethod = startMethod;
        this.stopMethod = stopMethod;
    }

    public void start(StartContext context) throws StartException {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Starting Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.startMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            throw new StartException(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("start()"), (Throwable)e);
        }
    }

    public void stop(StopContext context) {
        if (SarLogger.ROOT_LOGGER.isTraceEnabled()) {
            SarLogger.ROOT_LOGGER.tracef("Stopping Service: %s", context.getController().getName());
        }
        try {
            this.invokeLifecycleMethod(this.stopMethod, (LifecycleContext)context);
        }
        catch (Exception e) {
            SarLogger.ROOT_LOGGER.error(SarLogger.ROOT_LOGGER.failedExecutingLegacyMethod("stop()"), e);
        }
    }
}

