/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.HashMap;
import java.util.Map;

public enum Namespace {
    UNKNOWN(null),
    SECURITY_1_0("urn:jboss:domain:security:1.0"),
    SECURITY_1_1("urn:jboss:domain:security:1.1"),
    SECURITY_1_2("urn:jboss:domain:security:1.2");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = SECURITY_1_2;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

