package org.jboss.as.security.logging;

import java.util.Locale;
import javax.naming.OperationNotSupportedException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import javax.naming.InvalidNameException;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import javax.security.auth.login.LoginException;
import org.jboss.msc.service.StartException;
import java.util.Arrays;
import java.lang.ClassNotFoundException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.xml.stream.Location;


import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-10T13:33:19-0800")
public class SecurityLogger_$logger extends DelegatingBasicLogger implements SecurityLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SecurityLogger_$logger.class.getName();
    public SecurityLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void currentVersion(final String version) {
        super.log.logf(FQCN, INFO, null, currentVersion$str(), version);
    }
    protected String currentVersion$str() {
        return "WFLYSEC0001: Current PicketBox version=%s";
    }
    @Override
    public final void activatingSecuritySubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSecuritySubsystem$str());
    }
    protected String activatingSecuritySubsystem$str() {
        return "WFLYSEC0002: Activating Security Subsystem";
    }
    protected String unableToGetModuleClassLoader$str() {
        return "WFLYSEC0004: Unable to get the Module Class Loader";
    }
    @Override
    public final IllegalStateException unableToGetModuleClassLoader(final Throwable e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToGetModuleClassLoader$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String operationNotSupported$str() {
        return "WFLYSEC0005: Operation not supported : %s";
    }
    @Override
    public final OperationNotSupportedException operationNotSupported(final Method method) {
        final OperationNotSupportedException result = new OperationNotSupportedException(String.format(getLoggingLocale(), operationNotSupported$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingModuleName$str() {
        return "WFLYSEC0006: Missing module name for the %s";
    }
    @Override
    public final IllegalArgumentException missingModuleName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingModuleName$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String runtimeException$str() {
        return "WFLYSEC0007: Runtime Exception:";
    }
    @Override
    public final RuntimeException runtimeException(final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), runtimeException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullName$str() {
        return "WFLYSEC0009: Name cannot be null or empty";
    }
    @Override
    public final InvalidNameException nullName() {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), nullName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullArgument$str() {
        return "WFLYSEC0011: Argument %s is null";
    }
    @Override
    public final IllegalArgumentException nullArgument(final String arg) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullArgument$str(), arg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToStartException$str() {
        return "WFLYSEC0012: Unable to start the %s service";
    }
    @Override
    public final StartException unableToStartException(final String service, final Throwable t) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToStartException$str(), service), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cnfe$str() {
        return "WFLYSEC0013: Class not found : %s";
    }
    @Override
    public final ClassNotFoundException cnfe(final String name) {
        final ClassNotFoundException result = new ClassNotFoundException(String.format(getLoggingLocale(), cnfe$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityException$str() {
        return "WFLYSEC0015: Security Exception";
    }
    @Override
    public final SecurityException securityException(final Throwable t) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), securityException$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedOperationExceptionUseResourceDesc$str() {
        return "WFLYSEC0018: Use the ResourceDescriptionResolver variant";
    }
    @Override
    public final UnsupportedOperationException unsupportedOperationExceptionUseResourceDesc() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedOperationExceptionUseResourceDesc$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedOperation$str() {
        return "WFLYSEC0019: Unsupported Operation";
    }
    @Override
    public final UnsupportedOperationException unsupportedOperation() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedOperation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlStreamExceptionAuth$str() {
        return "WFLYSEC0022: A security domain can have either an <authentication> or <authentication-jaspi> element, not both";
    }
    @Override
    public final XMLStreamException xmlStreamExceptionAuth(final Location loc) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), xmlStreamExceptionAuth$str()), loc);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String xmlStreamExceptionMissingAttribute$str() {
        return "WFLYSEC0023: Missing required attribute: either %s or %s must be present";
    }
    @Override
    public final XMLStreamException xmlStreamExceptionMissingAttribute(final String a, final String b, final Location loc) {
        final XMLStreamException result = new XMLStreamException(String.format(getLoggingLocale(), xmlStreamExceptionMissingAttribute$str(), a, b), loc);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String loginModuleStackIllegalArgument$str() {
        return "WFLYSEC0024: auth-module references a login module stack that doesn't exist::%s";
    }
    @Override
    public final IllegalArgumentException loginModuleStackIllegalArgument(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), loginModuleStackIllegalArgument$str(), str));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressDidNotContainSecurityDomain$str() {
        return "WFLYSEC0025: Address did not contain a security domain name";
    }
    @Override
    public final IllegalArgumentException addressDidNotContainSecurityDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), addressDidNotContainSecurityDomain$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidUserException$str() {
        return "WFLYSEC0027: Invalid User";
    }
    @Override
    public final SecurityException invalidUserException() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), invalidUserException$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityManagementNotInjected$str() {
        return "WFLYSEC0028: Security Management not injected";
    }
    @Override
    public final SecurityException securityManagementNotInjected() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), securityManagementNotInjected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String realmNotFound$str() {
        return "WFLYSEC0029: Security realm '%s' not found.";
    }
    @Override
    public final SecurityException realmNotFound(final String name) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), realmNotFound$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failureCallingSecurityRealm$str() {
        return "WFLYSEC0031: Failure calling CallbackHandler '%s'";
    }
    @Override
    public final LoginException failureCallingSecurityRealm(final String cause) {
        final LoginException result = new LoginException(String.format(getLoggingLocale(), failureCallingSecurityRealm$str(), cause));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAuthenticationCacheAvailable$str() {
        return "WFLYSEC0032: No authentication cache for security domain '%s' available";
    }
    @Override
    public final OperationFailedException noAuthenticationCacheAvailable(final String securityDomain) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noAuthenticationCacheAvailable$str(), securityDomain));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noUserPrincipalFound$str() {
        return "WFLYSEC0033: No UserPrincipalFound constructing RemotingConnectionPrincipal.";
    }
    @Override
    public final IllegalStateException noUserPrincipalFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noUserPrincipalFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interruptedWaitingForSecurityDomain$str() {
        return "WFLYSEC0034: Interrupted waiting for security domain '%s'";
    }
    @Override
    public final OperationFailedException interruptedWaitingForSecurityDomain(final String securityDomainName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), interruptedWaitingForSecurityDomain$str(), securityDomainName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiredSecurityDomainServiceNotAvailable$str() {
        return "WFLYSEC0035: Required security domain is not available '%s'";
    }
    @Override
    public final OperationFailedException requiredSecurityDomainServiceNotAvailable(final String securityDomainName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), requiredSecurityDomainServiceNotAvailable$str(), securityDomainName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String passwordAgain$str() {
        return "WFLYSEC0061:  again: ";
    }
    @Override
    public final String passwordAgain() {
        return String.format(getLoggingLocale(), passwordAgain$str());
    }
    protected String unableToLocateJSSEConfig$str() {
        return "WFLYSEC0100: Legacy security domain %s doesn't contain a valid JSSE configuration";
    }
    @Override
    public final StartException unableToLocateJSSEConfig(final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToLocateJSSEConfig$str(), legacyDomainName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLocateComponentInJSSEDomain$str() {
        return "WFLYSEC0101: Unable to find a %s configuration in JSSE security domain %s";
    }
    @Override
    public final StartException unableToLocateComponentInJSSEDomain(final String componentName, final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unableToLocateComponentInJSSEDomain$str(), componentName, legacyDomainName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedManagerTypeNotFound$str() {
        return "WFLYSEC0102: Could not find a %s of type %s in the JSSE security domain %s";
    }
    @Override
    public final StartException expectedManagerTypeNotFound(final String managerName, final String managerType, final String legacyDomainName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), expectedManagerTypeNotFound$str(), managerName, managerType, legacyDomainName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateAuthorizationIdentity$str() {
        return "WFLYSEC0103: Unable to create AuthorizationIdentity: no authenticated Subject was found";
    }
    @Override
    public final IllegalStateException unableToCreateAuthorizationIdentity() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToCreateAuthorizationIdentity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void defaultCacheRequirementMissing(final String containerName, final String legacyCacheName) {
        super.log.logf(FQCN, WARN, null, defaultCacheRequirementMissing$str(), containerName, legacyCacheName);
    }
    protected String defaultCacheRequirementMissing$str() {
        return "WFLYSEC0104: Default %s cache capability missing.  Assuming %s as default-cache.";
    }
}
