/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.security.SecurityDomainResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;

class SecurityDomainAdd
extends AbstractAddStepHandler {
    static final SecurityDomainAdd INSTANCE = new SecurityDomainAdd();

    private SecurityDomainAdd() {
        super(new AttributeDefinition[]{SecurityDomainResourceDefinition.CACHE_TYPE});
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        String cacheType = SecurityDomainAdd.getAuthenticationCacheType(resource.getModel());
        if ("infinispan".equals(cacheType)) {
            context.registerAdditionalCapabilityRequirement(InfinispanRequirement.CONTAINER.resolve("security"), SecurityDomainResourceDefinition.LEGACY_SECURITY_DOMAIN.getDynamicName(context.getCurrentAddressValue()), SecurityDomainResourceDefinition.CACHE_TYPE.getName());
        }
    }

    static String getAuthenticationCacheType(ModelNode node) {
        String type = null;
        if (node.hasDefined("cache-type")) {
            type = node.get("cache-type").asString();
        }
        return type;
    }
}

