/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class SecuritySubsystemRootResourceDefinition
extends SimpleResourceDefinition {
    private static final RuntimeCapability<Void> SECURITY_SUBSYSTEM = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security").build();
    private static final RuntimeCapability<Void> SERVER_SECURITY_MANAGER = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.server-security-manager").build();
    private static final RuntimeCapability<Void> SUBJECT_FACTORY_CAP = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.subject-factory").build();
    private static final RuntimeCapability<Void> JACC_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.jacc").build();
    private static final RuntimeCapability<Void> JACC_CAPABILITY_TOMBSTONE = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.jacc.tombstone").build();
    private static final SensitiveTargetAccessConstraintDefinition MISC_SECURITY_SENSITIVITY = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("security", "misc-security", false, true, true));
    static final SecuritySubsystemRootResourceDefinition INSTANCE = new SecuritySubsystemRootResourceDefinition();
    static final SimpleAttributeDefinition DEEP_COPY_SUBJECT_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("deep-copy-subject-mode", ModelType.BOOLEAN, true).setAccessConstraints(new AccessConstraintDefinition[]{MISC_SECURITY_SENSITIVITY})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition INITIALIZE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initialize-jacc", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setRestartJVM()).setAllowExpression(true)).build();

    private SecuritySubsystemRootResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(SecurityExtension.PATH_SUBSYSTEM, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("security")).setAddHandler(SecuritySubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler(){

            protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.recordCapabilitiesAndRequirements(context, operation, resource);
                context.deregisterCapability(JACC_CAPABILITY.getName());
            }
        }).setCapabilities(new RuntimeCapability[]{SECURITY_SUBSYSTEM, SERVER_SECURITY_MANAGER, SUBJECT_FACTORY_CAP}));
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEEP_COPY_SUBJECT_MODE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEEP_COPY_SUBJECT_MODE}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)INITIALIZE_JACC, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{INITIALIZE_JACC}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
                CapabilityServiceSupport capabilitySupport = context.getCapabilityServiceSupport();
                boolean elytronJacc = capabilitySupport.hasCapability("org.wildfly.security.jacc-policy");
                if (resolvedValue.asBoolean() && elytronJacc) {
                    throw SecurityLogger.ROOT_LOGGER.unableToEnableJaccSupport();
                }
                return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, voidHandback);
            }

            protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
                super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
                boolean shouldRegister = this.resolveValue(context, attributeDefinition, newValue);
                boolean registered = this.resolveValue(context, attributeDefinition, oldValue);
                if (!shouldRegister) {
                    context.deregisterCapability(JACC_CAPABILITY.getName());
                }
                if (!registered && shouldRegister) {
                    context.registerCapability(JACC_CAPABILITY);
                }
            }

            private boolean resolveValue(OperationContext context, AttributeDefinition attributeDefinition, ModelNode node) {
                try {
                    return attributeDefinition.resolveValue(context, node).asBoolean();
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"javax.security.auth.message.api")});
    }

    private static class SecuritySubsystemAdd
    extends AbstractBoottimeAddStepHandler {
        public static final OperationStepHandler INSTANCE = new SecuritySubsystemAdd();

        private SecuritySubsystemAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            DEEP_COPY_SUBJECT_MODE.validateAndSet(operation, model);
            INITIALIZE_JACC.validateAndSet(operation, model);
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            if (INITIALIZE_JACC.resolveModelAttribute(context, resource.getModel()).asBoolean()) {
                context.registerCapability(JACC_CAPABILITY);
                if (context.isBooting()) {
                    context.registerCapability(JACC_CAPABILITY_TOMBSTONE);
                }
            }
        }
    }
}

