/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Arrays;
import org.jboss.as.security.vault.VaultInteraction;
import org.jboss.as.security.vault.VaultMessages;
import org.jboss.as.security.vault.VaultSession;

public class VaultInteractiveSession {
    private String salt;
    private String keystoreURL;
    private String encDir;
    private String keystoreAlias;
    private int iterationCount = 0;
    private VaultSession vaultNISession = null;

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println(VaultMessages.MESSAGES.noConsole());
            System.exit(1);
        }
        while (this.encDir == null || this.encDir.length() == 0) {
            this.encDir = console.readLine(VaultMessages.MESSAGES.enterEncryptionDirectory(), new Object[0]);
        }
        while (this.keystoreURL == null || this.keystoreURL.length() == 0) {
            this.keystoreURL = console.readLine(VaultMessages.MESSAGES.enterKeyStoreURL(), new Object[0]);
        }
        char[] keystorePasswd = VaultInteractiveSession.getSensitiveValue(VaultMessages.MESSAGES.enterKeyStorePassword());
        try {
            while (this.salt == null || this.salt.length() != 8) {
                this.salt = console.readLine(VaultMessages.MESSAGES.enterSalt(), new Object[0]);
            }
            String ic = console.readLine(VaultMessages.MESSAGES.enterIterationCount(), new Object[0]);
            this.iterationCount = Integer.parseInt(ic);
            this.vaultNISession = new VaultSession(this.keystoreURL, new String(keystorePasswd), this.encDir, this.salt, this.iterationCount);
            while (this.keystoreAlias == null || this.keystoreAlias.length() == 0) {
                this.keystoreAlias = console.readLine(VaultMessages.MESSAGES.enterKeyStoreAlias(), new Object[0]);
            }
            System.out.println(VaultMessages.MESSAGES.initializingVault());
            this.vaultNISession.startVaultSession(this.keystoreAlias);
            this.vaultNISession.vaultConfigurationDisplay();
            System.out.println(VaultMessages.MESSAGES.vaultInitialized());
            System.out.println(VaultMessages.MESSAGES.handshakeComplete());
            VaultInteraction vaultInteraction = new VaultInteraction(this.vaultNISession);
            vaultInteraction.start();
        }
        catch (Exception e) {
            System.out.println(VaultMessages.MESSAGES.exceptionEncountered() + e.getLocalizedMessage());
        }
    }

    public static char[] getSensitiveValue(String passwordPrompt) {
        char[] passwd;
        while (true) {
            char[] passwd1;
            Console console;
            boolean noMatch;
            if (passwordPrompt == null) {
                passwordPrompt = VaultMessages.MESSAGES.enterYourPassword();
            }
            boolean bl = noMatch = !Arrays.equals(passwd = (console = System.console()).readPassword(passwordPrompt + ": ", new Object[0]), passwd1 = console.readPassword(passwordPrompt + VaultMessages.MESSAGES.passwordAgain(), new Object[0]));
            if (!noMatch) break;
            System.out.println(VaultMessages.MESSAGES.passwordsDoNotMatch());
        }
        System.out.println(VaultMessages.MESSAGES.passwordsMatch());
        return passwd;
    }
}

