/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.creator.PackageBuilder;
import org.jboss.galleon.diff.FileSystemDiffResult;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;

public class WfDiffResult
extends FileSystemDiffResult {
    private final List<Path> scripts = new ArrayList<Path>();
    private final List<ConfigModel> configs = new ArrayList<ConfigModel>();
    private final Map<FeaturePackLocation.FPID, ConfigId> includedConfigs = new HashMap<FeaturePackLocation.FPID, ConfigId>();

    public WfDiffResult(Map<FeaturePackLocation.FPID, ConfigId> includedConfigs, List<ConfigModel> configs, List<Path> scripts, Set<Path> deletedFiles, Set<Path> addedFiles, Set<Path> modifiedBinaryFiles, Map<Path, List<String>> unifiedDiffs) {
        super(deletedFiles, addedFiles, modifiedBinaryFiles, unifiedDiffs);
        if (scripts != null) {
            this.scripts.addAll(scripts);
        }
        if (includedConfigs != null) {
            this.includedConfigs.putAll(includedConfigs);
        }
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public WfDiffResult(Map<FeaturePackLocation.FPID, ConfigId> includedConfigs, List<ConfigModel> configs, List<Path> scripts, FileSystemDiffResult result) {
        this(includedConfigs, configs, scripts, result.getDeletedFiles(), result.getAddedFiles(), result.getModifiedBinaryFiles(), result.getUnifiedDiffs());
    }

    public List<Path> getScripts() {
        return Collections.unmodifiableList(this.scripts);
    }

    public Map<FeaturePackLocation.FPID, ConfigId> getIncludedConfigs() {
        return Collections.unmodifiableMap(this.includedConfigs);
    }

    public List<ConfigModel> getConfigs() {
        return Collections.unmodifiableList(this.configs);
    }

    public FileSystemDiffResult merge(FileSystemDiffResult result) {
        super.merge(result);
        if (result instanceof WfDiffResult) {
            this.scripts.addAll(((WfDiffResult)result).getScripts());
            this.includedConfigs.putAll(((WfDiffResult)result).getIncludedConfigs());
            this.configs.addAll(((WfDiffResult)result).getConfigs());
        }
        return this;
    }

    public void toFeaturePack(FeaturePackBuilder fpBuilder, Map<String, FeaturePackConfig.Builder> builders, ProvisioningRuntime runtime, Path installationHome) throws ProvisioningException {
        super.toFeaturePack(fpBuilder, builders, runtime, installationHome);
        PackageBuilder updatedFiles = fpBuilder.newPackage("wildfly").setDefault();
        try {
            for (ConfigModel configModel : this.getConfigs()) {
                fpBuilder.addConfig(configModel);
            }
            for (Map.Entry entry : this.getIncludedConfigs().entrySet()) {
                String key = FeaturePackConfig.getDefaultOriginName((FeaturePackLocation)((FeaturePackLocation.FPID)entry.getKey()).getLocation());
                if (!builders.containsKey(key)) {
                    builders.put(key, FeaturePackConfig.builder((FeaturePackLocation)((FeaturePackLocation.FPID)entry.getKey()).getLocation()));
                }
                builders.get(key).includeDefaultConfig((ConfigId)entry.getValue());
            }
        }
        catch (Exception ex) {
            runtime.getMessageWriter().error((Throwable)ex, (CharSequence)ex.getMessage());
            throw new ProvisioningException((Throwable)ex);
        }
        updatedFiles.writeContent("pm/wildfly/tasks.xml", this.toTasks(), false);
    }

    private String toTasks() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version=\"1.0\" ?>");
        buffer.append(System.lineSeparator());
        buffer.append(System.lineSeparator());
        buffer.append(String.format("<tasks xmlns=\"%s\">", "urn:wildfly:wildfly-feature-pack-tasks:2.0"));
        buffer.append(System.lineSeparator());
        buffer.append("    <delete-paths>");
        buffer.append(System.lineSeparator());
        for (Path deleted : this.getDeletedFiles()) {
            buffer.append(String.format("        <delete path=\"%s\" recursive=\"%s\" />", deleted.toString(), false));
        }
        buffer.append("    </delete-paths>");
        buffer.append(System.lineSeparator());
        buffer.append("</tasks>");
        return buffer.toString();
    }
}

