/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.negotiation;

import org.apache.commons.lang.SystemUtils;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.logging.Logger;
import org.junit.internal.AssumptionViolatedException;

public final class KerberosTestUtils {
    private static final Logger LOGGER = Logger.getLogger(KerberosTestUtils.class);
    public static final boolean PREFER_IPV4_STACK = Boolean.parseBoolean(System.getProperty("java.net.preferIPv4Stack", "true"));
    public static final boolean PREFER_IPV6_ADDR = Boolean.getBoolean("java.net.preferIPv6Addresses");

    private KerberosTestUtils() {
    }

    public static void assumeKerberosAuthenticationSupported(String hostName) throws AssumptionViolatedException {
        if (Utils.IBM_JDK && KerberosTestUtils.isRunningOnIPv6()) {
            throw new AssumptionViolatedException("Kerberos tests are not supported on IBM Java with IPv6. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1188632");
        }
        if (KerberosTestUtils.isIPv6Hostname(hostName)) {
            if (Utils.IBM_JDK && SystemUtils.IS_JAVA_1_7) {
                throw new AssumptionViolatedException("Kerberos tests are not supported on IBM Java 7 with IPv6-based hostnames. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1185917");
            }
            if (Utils.IBM_JDK && SystemUtils.IS_JAVA_1_6) {
                throw new AssumptionViolatedException("Kerberos tests are not supported on IBM Java 6 with IPv6-based hostnames. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1186129");
            }
            if (Utils.OPEN_JDK && SystemUtils.IS_JAVA_1_6) {
                throw new AssumptionViolatedException("Kerberos tests are not supported on OpenJDK 6 with IPv6-based hostnames. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1186132");
            }
        }
    }

    public static void assumeEjbKerberosAuthenticationSupported(String hostName) {
        if (KerberosTestUtils.isIPv6Hostname(hostName) && Utils.ORACLE_JDK && SystemUtils.IS_JAVA_1_6) {
            throw new AssumptionViolatedException("Kerberos tests are not supported on Oracle Java 6 with IPv6-based hostnames. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1179710");
        }
        KerberosTestUtils.assumeKerberosAuthenticationSupported(hostName);
    }

    public static void assumeCLIKerberosAuthenticationSupported(String hostName) throws AssumptionViolatedException {
        if (Utils.IBM_JDK) {
            throw new AssumptionViolatedException("Kerberos CLI tests are not supported on IBM Java. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1174156");
        }
        if (Utils.ORACLE_JDK && SystemUtils.IS_JAVA_1_6) {
            throw new AssumptionViolatedException("Kerberos CLI tests are not supported on Oracle Java 6, because wrong support of KRB5CCNAME environment property. Find more info in https://bugzilla.redhat.com/show_bug.cgi?id=1173530#c3");
        }
        KerberosTestUtils.assumeKerberosAuthenticationSupported(hostName);
    }

    private static boolean isIPv6Hostname(String hostName) {
        if (hostName == null) {
            hostName = Utils.getDefaultHost(true);
            LOGGER.warn((Object)("Fallback to a default host is used hostname = " + hostName));
        }
        String formattedHost = NetworkUtils.formatPossibleIpv6Address((String)hostName);
        boolean isIPv6 = formattedHost.startsWith("[");
        return isIPv6;
    }

    private static boolean isRunningOnIPv6() {
        return !PREFER_IPV4_STACK && PREFER_IPV6_ADDR;
    }
}

