/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.test.integration.security.common.Coding;
import org.jboss.as.test.integration.security.common.CoreUtils;
import org.jboss.as.test.integration.security.common.Krb5LoginConfiguration;
import org.jboss.as.test.integration.security.common.ManagedCreateLdapServer;
import org.jboss.as.test.integration.security.common.ManagedCreateTransport;
import org.jboss.as.test.integration.security.common.NullHCCredentials;
import org.jboss.as.test.integration.security.common.negotiation.JBossNegotiateSchemeFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.junit.Assert;

public class Utils
extends CoreUtils {
    private static final Logger LOGGER = Logger.getLogger(Utils.class);
    public static final String UTF_8 = "UTF-8";
    public static final boolean IBM_JDK = StringUtils.startsWith((String)SystemUtils.JAVA_VENDOR, (String)"IBM");
    public static final boolean OPEN_JDK = StringUtils.startsWith((String)SystemUtils.JAVA_VM_NAME, (String)"OpenJDK");
    public static final boolean ORACLE_JDK = StringUtils.startsWith((String)SystemUtils.JAVA_VM_NAME, (String)"Java HotSpot");
    public static final RedirectStrategy REDIRECT_STRATEGY = new DefaultRedirectStrategy(){

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
            boolean isRedirect = false;
            try {
                isRedirect = super.isRedirected(request, response, context);
            }
            catch (ProtocolException e) {
                e.printStackTrace();
            }
            if (!isRedirect) {
                int responseCode = response.getStatusLine().getStatusCode();
                isRedirect = responseCode == 301 || responseCode == 302;
            }
            return isRedirect;
        }
    };
    private static final long STOP_DELAY_DEFAULT = 0L;

    public static String hashMD5(String value, Coding coding) {
        return coding == null || value == null ? value : Utils.hash(value, "MD5", coding);
    }

    public static String hash(String target, String algorithm, Coding coding) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(algorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        byte[] bytes = target.getBytes();
        byte[] byteHash = md.digest(bytes);
        String encodedHash = null;
        switch (coding) {
            case BASE_64: {
                encodedHash = Base64.getEncoder().encodeToString(byteHash);
                break;
            }
            case HEX: {
                encodedHash = Utils.toHex(byteHash);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsuported coding:" + coding.name());
            }
        }
        return encodedHash;
    }

    public static String toHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }

    public static URL getResource(String name) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return tccl.getResource(name);
    }

    public static void stop() {
        Utils.stop(0L);
    }

    public static void stop(long delay) {
        long remainingTime;
        long currentTime = System.currentTimeMillis();
        long l = remainingTime = 0L < delay ? currentTime + delay - System.currentTimeMillis() : Long.MAX_VALUE;
        while (remainingTime > 0L) {
            try {
                Thread.sleep(remainingTime);
            }
            catch (InterruptedException ex) {
                remainingTime = currentTime + delay - System.currentTimeMillis();
            }
        }
    }

    public static void applyUpdates(List<ModelNode> updates, ModelControllerClient client) throws Exception {
        for (ModelNode update : updates) {
            Utils.applyUpdate(update, client);
        }
    }

    public static void applyUpdate(ModelNode update, ModelControllerClient client) throws Exception {
        ModelNode result = client.execute(new OperationBuilder(update).build());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info((Object)("Client update: " + update));
            LOGGER.info((Object)("Client update result: " + result));
        }
        if (!result.hasDefined("outcome") || !"success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
        LOGGER.debug((Object)"Operation succeeded.");
    }

    public static String getContent(HttpResponse response) throws IOException {
        return EntityUtils.toString((HttpEntity)response.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeCall(String URL2, String user, String pass, int expectedStatusCode) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(URL2);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            StatusLine statusLine = response.getStatusLine();
            System.out.println("Login form get: " + statusLine);
            Assert.assertEquals((long)200L, (long)statusLine.getStatusCode());
            System.out.println("Initial set of cookies:");
            List cookies = httpclient.getCookieStore().getCookies();
            if (cookies.isEmpty()) {
                System.out.println("None");
            } else {
                for (int i = 0; i < cookies.size(); ++i) {
                    System.out.println("- " + ((Cookie)cookies.get(i)).toString());
                }
            }
            HttpPost httpost = new HttpPost(URL2 + "/j_security_check");
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("j_username", user));
            nvps.add(new BasicNameValuePair("j_password", pass));
            httpost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, UTF_8));
            response = httpclient.execute((HttpUriRequest)httpost);
            entity = response.getEntity();
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            statusLine = response.getStatusLine();
            Assert.assertEquals((long)302L, (long)statusLine.getStatusCode());
            Header locationHeader = response.getFirstHeader("Location");
            String location = locationHeader.getValue();
            HttpGet httpGet = new HttpGet(location);
            response = httpclient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            System.out.println("Post logon cookies:");
            cookies = httpclient.getCookieStore().getCookies();
            if (cookies.isEmpty()) {
                System.out.println("None");
            } else {
                for (int i = 0; i < cookies.size(); ++i) {
                    System.out.println("- " + ((Cookie)cookies.get(i)).toString());
                }
            }
            statusLine = response.getStatusLine();
            Assert.assertEquals((long)expectedStatusCode, (long)statusLine.getStatusCode());
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static void saveArchive(Archive<?> archive, String filePath) {
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(new File(filePath), true);
    }

    public static void saveArchiveToFolder(Archive<?> archive, String folderPath) {
        File exportFile = new File(folderPath, archive.getName());
        LOGGER.info((Object)("Exporting archive: " + exportFile.getAbsolutePath()));
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exportFile, true);
    }

    public static String getSecondaryTestAddress(ManagementClient mgmtClient, boolean useCanonicalHost) {
        String address = System.getProperty("secondary.test.address");
        if (StringUtils.isBlank((String)address) && mgmtClient != null) {
            address = mgmtClient.getMgmtAddress();
        }
        if (useCanonicalHost) {
            address = Utils.getCannonicalHost((String)address);
        }
        return Utils.stripSquareBrackets(address);
    }

    public static String getSecondaryTestAddress(ManagementClient mgmtClient) {
        return NetworkUtils.formatPossibleIpv6Address((String)Utils.getSecondaryTestAddress(mgmtClient, false));
    }

    public static String makeCallWithHttpClient(URL url, HttpClient httpClient, int expectedStatusCode) throws IOException, URISyntaxException {
        String httpResponseBody = null;
        HttpGet httpGet = new HttpGet(url.toURI());
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        LOGGER.info((Object)("Request to: " + url + " responds: " + statusCode));
        Assert.assertEquals((String)"Unexpected status code", (long)expectedStatusCode, (long)statusCode);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            httpResponseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            EntityUtils.consume((HttpEntity)entity);
        }
        return httpResponseBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeCallWithBasicAuthn(URL url, String user, String pass, int expectedStatusCode) throws IOException, URISyntaxException {
        LOGGER.info((Object)("Requesting URL " + url));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        try {
            HttpEntity entity;
            HttpGet httpGet = new HttpGet(url.toURI());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (401 != statusCode || StringUtils.isEmpty((String)user)) {
                Assert.assertEquals((String)"Unexpected HTTP response status code.", (long)expectedStatusCode, (long)statusCode);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("HTTP response was SC_UNAUTHORIZED, let's authenticate the user " + user));
            }
            if ((entity = response.getEntity()) != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, pass);
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(url.getHost(), url.getPort()), (Credentials)credentials);
            response = httpClient.execute((HttpUriRequest)httpGet);
            statusCode = response.getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeCallWithKerberosAuthn(URI uri, String user, String pass, final int expectedStatusCode) throws IOException, URISyntaxException, PrivilegedActionException, LoginException {
        LOGGER.info((Object)("Requesting URI: " + uri));
        final DefaultHttpClient httpClient = new DefaultHttpClient();
        Krb5LoginConfiguration krb5Configuration = new Krb5LoginConfiguration(Utils.getLoginConfiguration());
        try {
            httpClient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)new JBossNegotiateSchemeFactory(true));
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), (Credentials)new NullHCCredentials());
            final HttpGet httpGet = new HttpGet(uri);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (401 != statusCode || StringUtils.isEmpty((String)user)) {
                Assert.assertEquals((String)"Unexpected HTTP response status code.", (long)expectedStatusCode, (long)statusCode);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            HttpEntity entity = response.getEntity();
            Header[] authnHeaders = response.getHeaders("WWW-Authenticate");
            Assert.assertTrue((String)"WWW-Authenticate header is present", (authnHeaders != null && authnHeaders.length > 0 ? 1 : 0) != 0);
            HashSet<String> authnHeaderValues = new HashSet<String>();
            for (Header header : authnHeaders) {
                authnHeaderValues.add(header.getValue());
            }
            Assert.assertTrue((String)"WWW-Authenticate: Negotiate header is missing", (boolean)authnHeaderValues.contains("Negotiate"));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("HTTP response was SC_UNAUTHORIZED, let's authenticate the user " + user));
            }
            if (entity != null) {
                EntityUtils.consume((HttpEntity)entity);
            }
            Configuration.setConfiguration(krb5Configuration);
            LoginContext lc = Utils.loginWithKerberos(krb5Configuration, user, pass);
            String responseBody = Subject.doAs(lc.getSubject(), new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    int statusCode = response.getStatusLine().getStatusCode();
                    Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
                    return EntityUtils.toString((HttpEntity)response.getEntity());
                }
            });
            lc.logout();
            String string = responseBody;
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            krb5Configuration.resetConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeHttpCallWithFallback(String contextUrl, String page, String user, String pass, final int expectedStatusCode) throws IOException, URISyntaxException, PrivilegedActionException, LoginException {
        String strippedContextUrl = StringUtils.stripEnd((String)contextUrl, (String)"/");
        String url = strippedContextUrl + page;
        LOGGER.info((Object)("Requesting URL: " + url));
        final DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.setRedirectStrategy(REDIRECT_STRATEGY);
        String unauthorizedPageBody = null;
        Krb5LoginConfiguration krb5Configuration = new Krb5LoginConfiguration(Utils.getLoginConfiguration());
        try {
            httpClient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)new JBossNegotiateSchemeFactory(true));
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(null, -1, null), (Credentials)new NullHCCredentials());
            final HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (401 != statusCode || StringUtils.isEmpty((String)user)) {
                Assert.assertEquals((String)"Unexpected HTTP response status code.", (long)expectedStatusCode, (long)statusCode);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            Header[] authnHeaders = response.getHeaders("WWW-Authenticate");
            Assert.assertTrue((String)"WWW-Authenticate header is present", (authnHeaders != null && authnHeaders.length > 0 ? 1 : 0) != 0);
            HashSet<String> authnHeaderValues = new HashSet<String>();
            for (Header header : authnHeaders) {
                authnHeaderValues.add(header.getValue());
            }
            Assert.assertTrue((String)"WWW-Authenticate: Negotiate header is missing", (boolean)authnHeaderValues.contains("Negotiate"));
            LOGGER.debug((Object)("HTTP response was SC_UNAUTHORIZED, let's authenticate the user " + user));
            unauthorizedPageBody = EntityUtils.toString((HttpEntity)response.getEntity());
            Configuration.setConfiguration(krb5Configuration);
            LoginContext lc = Utils.loginWithKerberos(krb5Configuration, user, pass);
            String responseBody = Subject.doAs(lc.getSubject(), new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    int statusCode = response.getStatusLine().getStatusCode();
                    Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
                    return EntityUtils.toString((HttpEntity)response.getEntity());
                }
            });
            lc.logout();
            String string = responseBody;
            return string;
        }
        catch (LoginException e) {
            Assert.assertNotNull(unauthorizedPageBody);
            Assert.assertTrue((boolean)unauthorizedPageBody.contains("j_security_check"));
            HttpPost httpPost = new HttpPost(strippedContextUrl + "/j_security_check");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("j_username", user));
            nameValuePairs.add(new BasicNameValuePair("j_password", pass));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
            krb5Configuration.resetConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeHttpCallWoSPNEGO(String contextUrl, String page, String user, String pass, int expectedStatusCode) throws IOException, URISyntaxException, PrivilegedActionException, LoginException {
        String strippedContextUrl = StringUtils.stripEnd((String)contextUrl, (String)"/");
        String url = strippedContextUrl + page;
        LOGGER.info((Object)("Requesting URL: " + url));
        DefaultHttpClient httpClient = new DefaultHttpClient();
        httpClient.setRedirectStrategy(REDIRECT_STRATEGY);
        String unauthorizedPageBody = null;
        try {
            HttpGet httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (401 != statusCode || StringUtils.isEmpty((String)user)) {
                Assert.assertEquals((String)"Unexpected HTTP response status code.", (long)expectedStatusCode, (long)statusCode);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            Header[] authnHeaders = response.getHeaders("WWW-Authenticate");
            Assert.assertTrue((String)"WWW-Authenticate header is present", (authnHeaders != null && authnHeaders.length > 0 ? 1 : 0) != 0);
            HashSet<String> authnHeaderValues = new HashSet<String>();
            for (Header header : authnHeaders) {
                authnHeaderValues.add(header.getValue());
            }
            Assert.assertTrue((String)"WWW-Authenticate: Negotiate header is missing", (boolean)authnHeaderValues.contains("Negotiate"));
            LOGGER.debug((Object)("HTTP response was SC_UNAUTHORIZED, let's authenticate the user " + user));
            unauthorizedPageBody = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.assertNotNull((Object)unauthorizedPageBody);
            LOGGER.info((Object)unauthorizedPageBody);
            Assert.assertTrue((boolean)unauthorizedPageBody.contains("j_security_check"));
            HttpPost httpPost = new HttpPost(strippedContextUrl + "/j_security_check");
            ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
            nameValuePairs.add(new BasicNameValuePair("j_username", user));
            nameValuePairs.add(new BasicNameValuePair("j_password", pass));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
            response = httpClient.execute((HttpUriRequest)httpPost);
            statusCode = response.getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static String setSystemProperty(String key, String value) {
        return value == null ? System.clearProperty(key) : System.setProperty(key, value);
    }

    public static Asset getJBossEjb3XmlAsset(String securityDomain) {
        StringBuilder sb = new StringBuilder();
        sb.append("<jboss:ejb-jar xmlns:jboss='http://www.jboss.com/xml/ns/javaee'");
        sb.append("\n\txmlns='http://java.sun.com/xml/ns/javaee'");
        sb.append("\n\txmlns:s='urn:security'");
        sb.append("\n\tversion='3.1'");
        sb.append("\n\timpl-version='2.0'>");
        sb.append("\n\t<assembly-descriptor><s:security>");
        sb.append("\n\t\t<ejb-name>*</ejb-name>");
        sb.append("\n\t\t<s:security-domain>").append(securityDomain).append("</s:security-domain>");
        sb.append("\n\t</s:security></assembly-descriptor>");
        sb.append("\n</jboss:ejb-jar>");
        return new StringAsset(sb.toString());
    }

    public static Asset getJBossWebXmlAsset(String securityDomain, String ... valveClassNames) {
        StringBuilder sb = new StringBuilder();
        sb.append("<jboss-web>");
        sb.append("\n\t<security-domain>").append(securityDomain).append("</security-domain>");
        if (valveClassNames != null) {
            for (String valveClassName : valveClassNames) {
                if (!StringUtils.isNotEmpty((String)valveClassName)) continue;
                sb.append("\n\t<valve><class-name>").append(valveClassName).append("</class-name></valve>");
            }
        }
        sb.append("\n</jboss-web>");
        return new StringAsset(sb.toString());
    }

    public static Asset getJBossDeploymentStructure(String ... dependencies) {
        StringBuilder sb = new StringBuilder();
        sb.append("<jboss-deployment-structure><deployment><dependencies>");
        if (dependencies != null) {
            for (String moduleName : dependencies) {
                sb.append("\n\t<module name='").append(moduleName).append("'/>");
            }
        }
        sb.append("\n</dependencies></deployment></jboss-deployment-structure>");
        return new StringAsset(sb.toString());
    }

    public static String createUsersFromRoles(String ... roles) {
        StringBuilder sb = new StringBuilder();
        if (roles != null) {
            for (String role : roles) {
                sb.append(role).append("=").append(role).append("\n");
            }
        }
        return sb.toString();
    }

    public static String stripSquareBrackets(String str) {
        return StringUtils.strip((String)str, (String)"[]");
    }

    public static void fixApacheDSTransportAddress(ManagedCreateLdapServer createLdapServer, String address) {
        CreateTransport[] createTransports = createLdapServer.transports();
        for (int i = 0; i < createTransports.length; ++i) {
            ManagedCreateTransport mgCreateTransport = new ManagedCreateTransport(createTransports[i]);
            mgCreateTransport.setAddress(address != null ? address : "localhost");
            createTransports[i] = mgCreateTransport;
        }
    }

    public static void createKeyMaterial(File workingFolder) throws IOException, IllegalArgumentException {
        if (workingFolder == null || !workingFolder.isDirectory()) {
            throw new IllegalArgumentException("Provide an existing folder as the method parameter.");
        }
        Utils.createTestResource(new File(workingFolder, "server.keystore"));
        Utils.createTestResource(new File(workingFolder, "server.truststore"));
        Utils.createTestResource(new File(workingFolder, "server.crt"));
        Utils.createTestResource(new File(workingFolder, "client.keystore"));
        Utils.createTestResource(new File(workingFolder, "client.truststore"));
        Utils.createTestResource(new File(workingFolder, "client.crt"));
        Utils.createTestResource(new File(workingFolder, "untrusted.keystore"));
        Utils.createTestResource(new File(workingFolder, "untrusted.crt"));
        LOGGER.info((Object)("Key material created in " + workingFolder.getAbsolutePath()));
    }

    private static void createTestResource(File file) throws IOException {
        FileOutputStream fos = null;
        LOGGER.info((Object)("Creating test file " + file.getAbsolutePath()));
        try {
            fos = new FileOutputStream(file);
            IOUtils.copy((InputStream)CoreUtils.class.getResourceAsStream(file.getName()), (OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public static String propertiesReplacer(String originalFile, File keystoreFile, File trustStoreFile, String keystorePassword) {
        return Utils.propertiesReplacer(originalFile, keystoreFile.getAbsolutePath(), trustStoreFile.getAbsolutePath(), keystorePassword, null);
    }

    public static String propertiesReplacer(String originalFile, File keystoreFile, File trustStoreFile, String keystorePassword, String vaultConfig) {
        return Utils.propertiesReplacer(originalFile, keystoreFile.getAbsolutePath(), trustStoreFile.getAbsolutePath(), keystorePassword, vaultConfig);
    }

    public static String propertiesReplacer(String originalFile, String keystoreFile, String trustStoreFile, String keystorePassword, String vaultConfig) {
        String hostname = Utils.getDefaultHost(false);
        try {
            hostname = NetworkUtils.formatPossibleIpv6Address((String)InetAddress.getByName(hostname).getHostAddress());
        }
        catch (UnknownHostException ex) {
            String message = "Cannot resolve host address: " + hostname + " , error : " + ex.getMessage();
            LOGGER.error((Object)message);
            throw new RuntimeException(ex);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String content = "";
        if (vaultConfig == null) {
            map.put("vaultConfig", "");
        } else {
            map.put("vaultConfig", vaultConfig);
        }
        map.put("hostname", hostname);
        map.put("keystore", keystoreFile);
        map.put("truststore", trustStoreFile);
        map.put("password", keystorePassword);
        try {
            content = StrSubstitutor.replace((Object)IOUtils.toString((InputStream)CoreUtils.class.getResourceAsStream(originalFile), (String)UTF_8), map);
        }
        catch (IOException ex) {
            String message = "Cannot find or modify configuration file " + originalFile + " , error : " + ex.getMessage();
            LOGGER.error((Object)message);
            throw new RuntimeException(ex);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeCall(URI uri, int expectedStatusCode) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        try {
            HttpGet httpget = new HttpGet(uri);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            int statusCode = response.getStatusLine().getStatusCode();
            Assert.assertEquals((String)"Unexpected status code returned after the authentication.", (long)expectedStatusCode, (long)statusCode);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        finally {
            httpclient.getConnectionManager().shutdown();
        }
    }

    public static String encodeQueryParam(String paramName, String paramValue) {
        String response = null;
        try {
            response = StringUtils.isEmpty((String)paramValue) ? null : URLEncoder.encode(paramName, UTF_8) + "=" + URLEncoder.encode(StringUtils.defaultString((String)paramValue, (String)""), UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return response;
    }

    public static final String getHost(ManagementClient managementClient) {
        return CoreUtils.stripSquareBrackets((String)managementClient.getMgmtAddress());
    }

    public static final String getCannonicalHost(ManagementClient managementClient) {
        return Utils.getCannonicalHost((String)managementClient.getMgmtAddress());
    }

    public static final URI getServletURI(URL webAppURL, String servletPath, ManagementClient mgmtClient, boolean useCanonicalHost) throws URISyntaxException {
        URI resultURI = new URI(webAppURL.toExternalForm() + servletPath.substring(1));
        if (useCanonicalHost) {
            resultURI = Utils.replaceHost((URI)resultURI, (String)Utils.getCannonicalHost(mgmtClient));
        }
        return resultURI;
    }

    public static String getDefaultHost(boolean canonical) {
        String hostname = System.getProperty("node0", "127.0.0.1");
        return canonical ? Utils.getCannonicalHost((String)hostname) : hostname;
    }

    public static Configuration getLoginConfiguration() {
        return Configuration.getConfiguration();
    }

    public static LoginContext loginWithKerberos(Krb5LoginConfiguration krb5Configuration, String user, String pass) throws LoginException {
        LoginContext lc = new LoginContext(krb5Configuration.getName(), (CallbackHandler)new UsernamePasswordHandler(user, (Object)pass));
        if (IBM_JDK) {
            lc.login();
            lc.logout();
            lc = new LoginContext(krb5Configuration.getName(), (CallbackHandler)new UsernamePasswordHandler(user, (Object)pass));
        }
        lc.login();
        return lc;
    }
}

