/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Permission;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public final class PermissionUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Asset createPermissionsXmlAsset(Permission ... permissions) {
        Element permissionsElement = new Element("permissions");
        permissionsElement.setNamespaceURI("http://xmlns.jcp.org/xml/ns/javaee");
        permissionsElement.addAttribute(new Attribute("version", "7"));
        for (Permission permission : permissions) {
            Element permissionElement = new Element("permission");
            Element classNameElement = new Element("class-name");
            Element nameElement = new Element("name");
            classNameElement.appendChild(permission.getClass().getName());
            nameElement.appendChild(permission.getName());
            permissionElement.appendChild((Node)classNameElement);
            permissionElement.appendChild((Node)nameElement);
            String actions = permission.getActions();
            if (actions != null && !actions.isEmpty()) {
                Element actionsElement = new Element("actions");
                actionsElement.appendChild(actions);
                permissionElement.appendChild((Node)actionsElement);
            }
            permissionsElement.appendChild((Node)permissionElement);
        }
        Document document = new Document(permissionsElement);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            NiceSerializer serializer = new NiceSerializer(stream);
            serializer.setIndent(4);
            serializer.setLineSeparator("\n");
            serializer.write(document);
            serializer.flush();
            StringAsset stringAsset = new StringAsset(stream.toString("UTF-8"));
            return stringAsset;
        }
        catch (IOException e) {
            throw new IllegalStateException("Generating permissions.xml failed", e);
        }
    }

    static class NiceSerializer
    extends Serializer {
        public NiceSerializer(OutputStream out) throws UnsupportedEncodingException {
            super(out, "UTF-8");
        }

        protected void writeXMLDeclaration() throws IOException {
            super.writeXMLDeclaration();
            super.breakLine();
        }
    }
}

