/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.IOException;
import java.util.LinkedList;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.security.common.AbstractSecurityDomainSetup;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.dmr.ModelNode;

public class EjbElytronDomainSetup
extends AbstractSecurityDomainSetup {
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "ejb3-tests";
    private PathAddress realmAddress;
    private PathAddress domainAddress;
    private PathAddress saslAuthenticationAddress;
    private PathAddress remotingConnectorAddress;
    private PathAddress ejbDomainAddress;
    private PathAddress ejbRemoteAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "ejb3").append("service", "remote");
    private PathAddress httpAuthenticationAddress;
    private PathAddress undertowDomainAddress;
    private final String usersFile;
    private final String groupsFile;
    private final String securityDomainName;

    public EjbElytronDomainSetup(String usersFile, String groupsFile) {
        this(usersFile, groupsFile, DEFAULT_SECURITY_DOMAIN_NAME);
    }

    public EjbElytronDomainSetup(String usersFile, String groupsFile, String securityDomainName) {
        this.usersFile = usersFile;
        this.groupsFile = groupsFile;
        this.securityDomainName = securityDomainName;
    }

    @Override
    protected String getSecurityDomainName() {
        return this.securityDomainName;
    }

    protected String getSecurityRealmName() {
        return this.getSecurityDomainName() + "-ejb3-UsersRoles";
    }

    protected String getUndertowDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getEjbDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getSaslAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getRemotingConnectorName() {
        return "http-remoting-connector";
    }

    protected String getHttpAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getUsersFile() {
        return this.usersFile;
    }

    protected String getGroupsFile() {
        return this.groupsFile;
    }

    protected boolean isUsersFilePlain() {
        return true;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.realmAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("properties-realm", this.getSecurityRealmName());
        this.domainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("security-domain", this.getSecurityDomainName());
        this.saslAuthenticationAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("sasl-authentication-factory", this.getSaslAuthenticationName());
        this.remotingConnectorAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "remoting").append("http-connector", this.getRemotingConnectorName());
        this.ejbDomainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "ejb3").append("application-security-domain", this.getEjbDomainName());
        this.httpAuthenticationAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("http-authentication-factory", this.getHttpAuthenticationName());
        this.undertowDomainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "undertow").append("application-security-domain", this.getUndertowDomainName());
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        ModelNode addRealm = Util.createAddOperation((PathAddress)this.realmAddress);
        addRealm.get("users-properties").get("path").set(this.getUsersFile());
        addRealm.get("users-properties").get("plain-text").set(this.isUsersFilePlain());
        addRealm.get("groups-properties").get("path").set(this.getGroupsFile());
        steps.add(addRealm);
        ModelNode addDomain = Util.createAddOperation((PathAddress)this.domainAddress);
        addDomain.get("permission-mapper").set("default-permission-mapper");
        addDomain.get("default-realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("role-decoder").set("groups-to-roles");
        addDomain.get("realms").get(1).get("realm").set("local");
        steps.add(addDomain);
        ModelNode addSaslAuthentication = Util.createAddOperation((PathAddress)this.saslAuthenticationAddress);
        addSaslAuthentication.get("sasl-server-factory").set("configured");
        addSaslAuthentication.get("security-domain").set(this.getSecurityDomainName());
        addSaslAuthentication.get("mechanism-configurations").get(0).get("mechanism-name").set("JBOSS-LOCAL-USER");
        addSaslAuthentication.get("mechanism-configurations").get(0).get("realm-mapper").set("local");
        addSaslAuthentication.get("mechanism-configurations").get(1).get("mechanism-name").set("DIGEST-MD5");
        addSaslAuthentication.get("mechanism-configurations").get(1).get("mechanism-realm-configurations").get(0).get("realm-name").set(this.getSecurityRealmName());
        steps.add(addSaslAuthentication);
        ModelNode updateRemotingConnector = Util.getWriteAttributeOperation((PathAddress)this.remotingConnectorAddress, (String)"sasl-authentication-factory", (String)this.getSaslAuthenticationName());
        steps.add(updateRemotingConnector);
        ModelNode addEjbDomain = Util.createAddOperation((PathAddress)this.ejbDomainAddress);
        addEjbDomain.get("security-domain").set(this.getSecurityDomainName());
        steps.add(addEjbDomain);
        ModelNode addHttpAuthentication = Util.createAddOperation((PathAddress)this.httpAuthenticationAddress);
        addHttpAuthentication.get("security-domain").set(this.getSecurityDomainName());
        addHttpAuthentication.get("http-server-mechanism-factory").set("global");
        addHttpAuthentication.get("mechanism-configurations").get(0).get("mechanism-name").set("BASIC");
        addHttpAuthentication.get("mechanism-configurations").get(0).get("mechanism-realm-configurations").get(0).get("realm-name").set("TestingRealm");
        steps.add(addHttpAuthentication);
        ModelNode addUndertowDomain = Util.createAddOperation((PathAddress)this.undertowDomainAddress);
        addUndertowDomain.get("http-authentication-factory").set(this.getHttpAuthenticationName());
        steps.add(addUndertowDomain);
        EjbElytronDomainSetup.applyUpdate(managementClient.getControllerClient(), compositeOp, false);
        ServerReload.reloadIfRequired(managementClient.getControllerClient());
    }

    @Override
    public void tearDown(ManagementClient managementClient, String containerId) {
        try {
            EjbElytronDomainSetup.applyUpdate(managementClient.getControllerClient(), Util.getWriteAttributeOperation((PathAddress)this.remotingConnectorAddress, (String)"sasl-authentication-factory", (String)"application-sasl-authentication"), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            ServerReload.reloadIfRequired(managementClient.getControllerClient());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LinkedList updates = new LinkedList();
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.undertowDomainAddress, false);
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.httpAuthenticationAddress, false);
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.ejbDomainAddress, false);
        try {
            ServerReload.executeReloadAndWaitForCompletion(managementClient.getControllerClient());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.saslAuthenticationAddress, false);
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.domainAddress, false);
        EjbElytronDomainSetup.applyRemoveAllowReload(managementClient.getControllerClient(), this.realmAddress, false);
    }

    private static void applyRemoveAllowReload(ModelControllerClient client, PathAddress address, boolean allowFailure) {
        ModelNode op = Util.createRemoveOperation((PathAddress)address);
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
        try {
            EjbElytronDomainSetup.applyUpdate(client, op, allowFailure);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

