/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common.jms;

import java.util.Map;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.common.jms.JMSOperations;
import org.jboss.as.test.integration.common.jms.JMSOperationsProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ActiveMQProviderJMSOperations
implements JMSOperations {
    private final ModelControllerClient client;
    private static final ModelNode serverAddress = new ModelNode();

    public ActiveMQProviderJMSOperations(ModelControllerClient client) {
        this.client = client;
    }

    public ActiveMQProviderJMSOperations(ManagementClient client) {
        this.client = client.getControllerClient();
    }

    @Override
    public ModelControllerClient getControllerClient() {
        return this.client;
    }

    @Override
    public ModelNode getServerAddress() {
        return serverAddress.clone();
    }

    @Override
    public String getProviderName() {
        return "activemq";
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName) {
        this.createJmsQueue(queueName, jndiName, new ModelNode());
    }

    @Override
    public void createJmsQueue(String queueName, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("jms-queue", queueName);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName) {
        this.createJmsTopic(topicName, jndiName, new ModelNode());
    }

    @Override
    public void createJmsTopic(String topicName, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("jms-topic", topicName);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsQueue(String queueName) {
        ModelNode address = this.getServerAddress().add("jms-queue", queueName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void removeJmsTopic(String topicName) {
        ModelNode address = this.getServerAddress().add("jms-topic", topicName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addJmsConnectionFactory(String name, String jndiName, ModelNode attributes) {
        ModelNode address = this.getServerAddress().add("connection-factory", name);
        attributes.get("entries").add(jndiName);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsConnectionFactory(String name) {
        ModelNode address = this.getServerAddress().add("connection-factory", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addJmsBridge(String name, ModelNode attributes) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging-activemq");
        address.add("jms-bridge", name);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeJmsBridge(String name) {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging-activemq");
        address.add("jms-bridge", name);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void addCoreQueue(String queueName, String queueAddress, boolean durable) {
        ModelNode address = this.getServerAddress().add("queue", queueName);
        ModelNode attributes = new ModelNode();
        attributes.get("queue-address").set(queueAddress);
        attributes.get("durable").set(durable);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeCoreQueue(String queueName) {
        ModelNode address = this.getServerAddress().add("queue", queueName);
        this.executeOperation(address, "remove", null);
    }

    @Override
    public void createRemoteAcceptor(String name, String socketBinding, Map<String, String> params) {
        ModelNode model = this.getServerAddress().add("remote-acceptor", name);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        if (params != null) {
            for (String key : params.keySet()) {
                model.get("params").add(key, params.get(key));
            }
        }
        this.executeOperation(model, "add", attributes);
    }

    @Override
    public void removeRemoteAcceptor(String name) {
        ModelNode model = this.getServerAddress().add("remote-acceptor", name);
        this.executeOperation(model, "remove", null);
    }

    @Override
    public void close() {
    }

    private void executeOperation(ModelNode address, String opName, ModelNode attributes) {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(opName);
        operation.get("address").set(address);
        if (attributes != null) {
            for (Property property : attributes.asPropertyList()) {
                operation.get(property.getName()).set(property.getValue());
            }
        }
        try {
            JMSOperationsProvider.execute(this.client, operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSystemProperties(String destination, String resourceAdapter) {
        ModelNode enableSubstitutionOp = new ModelNode();
        enableSubstitutionOp.get("address").set("subsystem", "ee");
        enableSubstitutionOp.get("operation").set("write-attribute");
        enableSubstitutionOp.get("name").set("annotation-property-replacement");
        enableSubstitutionOp.get("value").set(true);
        ModelNode setDestinationOp = new ModelNode();
        setDestinationOp.get("operation").set("add");
        setDestinationOp.get("address").add("system-property", "destination");
        setDestinationOp.get("value").set(destination);
        ModelNode setResourceAdapterOp = new ModelNode();
        setResourceAdapterOp.get("operation").set("add");
        setResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        setResourceAdapterOp.get("value").set(resourceAdapter);
        try {
            JMSOperationsProvider.execute(this.client, enableSubstitutionOp);
            JMSOperationsProvider.execute(this.client, setDestinationOp);
            JMSOperationsProvider.execute(this.client, setResourceAdapterOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeSystemProperties() {
        ModelNode removeDestinationOp = new ModelNode();
        removeDestinationOp.get("operation").set("remove");
        removeDestinationOp.get("address").add("system-property", "destination");
        ModelNode removeResourceAdapterOp = new ModelNode();
        removeResourceAdapterOp.get("operation").set("remove");
        removeResourceAdapterOp.get("address").add("system-property", "resource.adapter");
        ModelNode disableSubstitutionOp = new ModelNode();
        disableSubstitutionOp.get("address").set("subsystem", "ee");
        disableSubstitutionOp.get("operation").set("write-attribute");
        disableSubstitutionOp.get("name").set("annotation-property-replacement");
        disableSubstitutionOp.get("value").set(false);
        try {
            JMSOperationsProvider.execute(this.client, removeDestinationOp);
            JMSOperationsProvider.execute(this.client, removeResourceAdapterOp);
            JMSOperationsProvider.execute(this.client, disableSubstitutionOp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addHttpConnector(String connectorName, String socketBinding, String endpoint) {
        ModelNode address = this.getServerAddress().add("http-connector", connectorName);
        ModelNode attributes = new ModelNode();
        attributes.get("socket-binding").set(socketBinding);
        attributes.get("endpoint").set(endpoint);
        this.executeOperation(address, "add", attributes);
    }

    @Override
    public void removeHttpConnector(String connectorName) {
        ModelNode address = this.getServerAddress().add("http-connector", connectorName);
        this.executeOperation(address, "remove", null);
    }

    static {
        serverAddress.add("subsystem", "messaging-activemq");
        serverAddress.add("server", "default");
    }
}

