/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.ModelNodeUtil;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.SecurityDomain;

public class SimpleSecurityDomain
extends AbstractConfigurableElement
implements SecurityDomain {
    private final String defaultRealm;
    private final Boolean outflowAnonymous;
    private final String[] outflowSecurityDomains;
    private final String permissionMapper;
    private final String preRealmPrincipalTransformer;
    private final String postRealmPrincipalTransformer;
    private final String principalDecoder;
    private final String realmMapper;
    private final SecurityDomainRealm[] realms;
    private final String roleMapper;
    private final String securityEventListener;
    private final String[] trustedSecurityDomains;

    private SimpleSecurityDomain(Builder builder) {
        super(builder);
        this.defaultRealm = builder.defaultRealm;
        this.outflowAnonymous = builder.outflowAnonymous;
        this.outflowSecurityDomains = builder.outflowSecurityDomains;
        this.permissionMapper = builder.permissionMapper;
        this.preRealmPrincipalTransformer = builder.preRealmPrincipalTransformer;
        this.postRealmPrincipalTransformer = builder.postRealmPrincipalTransformer;
        this.principalDecoder = builder.principalDecoder;
        this.realmMapper = builder.realmMapper;
        this.realms = builder.realms;
        this.roleMapper = builder.roleMapper;
        this.securityEventListener = builder.securityEventListener;
        this.trustedSecurityDomains = builder.trustedSecurityDomains;
    }

    @Override
    public void create(ModelControllerClient client, CLIWrapper cli) throws Exception {
        ModelNode op = Util.createAddOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("security-domain", this.name));
        op.get("default-realm").set(this.defaultRealm);
        if (this.outflowAnonymous != null) {
            op.get("outflow-anonymous").set(this.outflowAnonymous.booleanValue());
        }
        ModelNodeUtil.setIfNotNull(op, "outflow-security-domains", this.outflowSecurityDomains);
        ModelNodeUtil.setIfNotNull(op, "permission-mapper", this.permissionMapper);
        ModelNodeUtil.setIfNotNull(op, "post-realm-principal-transformer", this.postRealmPrincipalTransformer);
        ModelNodeUtil.setIfNotNull(op, "pre-realm-principal-transformer", this.preRealmPrincipalTransformer);
        ModelNodeUtil.setIfNotNull(op, "principal-decoder", this.principalDecoder);
        ModelNodeUtil.setIfNotNull(op, "realm-mapper", this.realmMapper);
        if (this.realms != null) {
            ModelNode realmsNode = op.get("realms");
            for (SecurityDomainRealm realmRef : this.realms) {
                ModelNode realmRefNode = new ModelNode();
                realmRefNode.get("realm").set(realmRef.realm);
                ModelNodeUtil.setIfNotNull(realmRefNode, "principal-transformer", realmRef.principalTransformer);
                ModelNodeUtil.setIfNotNull(realmRefNode, "role-decoder", realmRef.roleDecoder);
                ModelNodeUtil.setIfNotNull(realmRefNode, "role-mapper", realmRef.roleMapper);
                realmsNode.add(realmRefNode);
            }
        }
        ModelNodeUtil.setIfNotNull(op, "role-mapper", this.roleMapper);
        ModelNodeUtil.setIfNotNull(op, "security-event-listener", this.securityEventListener);
        ModelNodeUtil.setIfNotNull(op, "trusted-security-domains", this.trustedSecurityDomains);
        Utils.applyUpdate(op, client);
    }

    @Override
    public void remove(ModelControllerClient client, CLIWrapper cli) throws Exception {
        Utils.applyUpdate(Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("security-domain", this.name)), client);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class SecurityDomainRealm {
        private final String realm;
        private final String principalTransformer;
        private final String roleDecoder;
        private final String roleMapper;

        private SecurityDomainRealm(Builder builder) {
            this.realm = builder.realm;
            this.principalTransformer = builder.principalTransformer;
            this.roleDecoder = builder.roleDecoder;
            this.roleMapper = builder.roleMapper;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String realm;
            private String principalTransformer;
            private String roleDecoder;
            private String roleMapper;

            private Builder() {
            }

            public Builder withRealm(String realm) {
                this.realm = realm;
                return this;
            }

            public Builder withPrincipalTransformer(String principalTransformer) {
                this.principalTransformer = principalTransformer;
                return this;
            }

            public Builder withRoleDecoder(String roleDecoder) {
                this.roleDecoder = roleDecoder;
                return this;
            }

            public Builder withRoleMapper(String roleMapper) {
                this.roleMapper = roleMapper;
                return this;
            }

            public SecurityDomainRealm build() {
                return new SecurityDomainRealm(this);
            }
        }
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String defaultRealm;
        private Boolean outflowAnonymous;
        private String[] outflowSecurityDomains;
        private String permissionMapper;
        private String preRealmPrincipalTransformer;
        private String postRealmPrincipalTransformer;
        private String principalDecoder;
        private String realmMapper;
        private SecurityDomainRealm[] realms;
        private String roleMapper;
        private String securityEventListener;
        private String[] trustedSecurityDomains;

        private Builder() {
        }

        public Builder withDefaultRealm(String defaultRealm) {
            this.defaultRealm = defaultRealm;
            return this;
        }

        public Builder withOutflowAnonymous(Boolean outflowAnonymous) {
            this.outflowAnonymous = outflowAnonymous;
            return this;
        }

        public Builder withOutflowSecurityDomains(String ... outflowSecurityDomains) {
            this.outflowSecurityDomains = outflowSecurityDomains;
            return this;
        }

        public Builder withPermissionMapper(String permissionMapper) {
            this.permissionMapper = permissionMapper;
            return this;
        }

        public Builder withPreRealmPrincipalTransformer(String preRealmPrincipalTransformer) {
            this.preRealmPrincipalTransformer = preRealmPrincipalTransformer;
            return this;
        }

        public Builder withPostRealmPrincipalTransformer(String postRealmPrincipalTransformer) {
            this.postRealmPrincipalTransformer = postRealmPrincipalTransformer;
            return this;
        }

        public Builder withPrincipalDecoder(String principalDecoder) {
            this.principalDecoder = principalDecoder;
            return this;
        }

        public Builder withRealmMapper(String realmMapper) {
            this.realmMapper = realmMapper;
            return this;
        }

        public Builder withRealms(SecurityDomainRealm ... realms) {
            this.realms = realms;
            return this;
        }

        public Builder withRoleMapper(String roleMapper) {
            this.roleMapper = roleMapper;
            return this;
        }

        public Builder withSecurityEventListener(String securityEventListener) {
            this.securityEventListener = securityEventListener;
            return this;
        }

        public Builder withTrustedSecurityDomains(String[] trustedSecurityDomains) {
            this.trustedSecurityDomains = trustedSecurityDomains;
            return this;
        }

        public SimpleSecurityDomain build() {
            return new SimpleSecurityDomain(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

