/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.negotiation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.jboss.logging.Logger;
import org.junit.AssumptionViolatedException;

public final class KerberosTestUtils {
    private static final Logger LOGGER = Logger.getLogger(KerberosTestUtils.class);
    public static final String OID_KERBEROS_V5 = "1.2.840.113554.1.2.2";
    public static final String OID_KERBEROS_V5_LEGACY = "1.2.840.48018.1.2.2";
    public static final String OID_NTLM = "1.3.6.1.4.1.311.2.2.10";
    public static final String OID_SPNEGO = "1.3.6.1.5.5.2";
    public static final String OID_DUMMY = "1.1.2.5.6.7";

    private KerberosTestUtils() {
    }

    public static void assumeKerberosAuthenticationSupported() throws AssumptionViolatedException {
        if (KerberosTestUtils.isIPV6()) {
            throw new AssumptionViolatedException("Kerberos tests are not supported when hostname is not available for tested IPv6 address. Find more info in https://issues.jboss.org/browse/WFLY-5409");
        }
    }

    private static boolean isIPV6() {
        return System.getProperty("ipv6") != null;
    }

    public static byte[] generateSpnegoTokenInit(byte[] ticket, String ... supMechOids) throws IOException {
        DEROctetString ticketForPreferredMech = new DEROctetString(ticket);
        ASN1EncodableVector mechSeq = new ASN1EncodableVector();
        for (String mech : supMechOids) {
            mechSeq.add((ASN1Encodable)new ASN1ObjectIdentifier(mech));
        }
        DERTaggedObject taggedMechTypes = new DERTaggedObject(0, (ASN1Encodable)new DERSequence(mechSeq));
        DERTaggedObject taggedMechToken = new DERTaggedObject(2, (ASN1Encodable)ticketForPreferredMech);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)taggedMechTypes);
        v.add((ASN1Encodable)taggedMechToken);
        DERSequence seqNegTokenInit = new DERSequence(v);
        DERTaggedObject taggedSpnego = new DERTaggedObject(0, (ASN1Encodable)seqNegTokenInit);
        ASN1EncodableVector appVec = new ASN1EncodableVector();
        appVec.add((ASN1Encodable)new ASN1ObjectIdentifier(OID_SPNEGO));
        appVec.add((ASN1Encodable)taggedSpnego);
        DERApplicationSpecific app = new DERApplicationSpecific(0, appVec);
        return app.getEncoded();
    }

    public static byte[] generateSpnegoTokenResp(byte[] ticket) throws IOException {
        DEROctetString ourKerberosTicket = new DEROctetString(ticket);
        DERTaggedObject taggedNegState = new DERTaggedObject(0, (ASN1Encodable)new ASN1Enumerated(1));
        DERTaggedObject taggedResponseToken = new DERTaggedObject(2, (ASN1Encodable)ourKerberosTicket);
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)taggedNegState);
        v.add((ASN1Encodable)taggedResponseToken);
        DERSequence seqNegTokenResp = new DERSequence(v);
        DERTaggedObject taggedSpnego = new DERTaggedObject(1, (ASN1Encodable)seqNegTokenResp);
        return taggedSpnego.getEncoded();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String dumpAsn1Obj(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try (ASN1InputStream bIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(data));){
            String string = ASN1Dump.dumpAsString((Object)bIn.readObject(), (boolean)true);
            return string;
        }
        catch (Exception e) {
            LOGGER.debug((Object)"ASN1Dump failed", (Throwable)e);
            return "[Unable to dump ASN.1: " + Base64.getEncoder().encodeToString(data) + " ]";
        }
    }

    public static String dumpNegotiateHeader(HttpResponse response) throws IOException {
        if (response == null) {
            return null;
        }
        String negotiatePrefix = "Negotiate ";
        for (Header header : response.getHeaders("WWW-Authenticate")) {
            String value = header.getValue();
            if (!value.startsWith("Negotiate ")) continue;
            byte[] token = Base64.getDecoder().decode(value.substring("Negotiate ".length()));
            return KerberosTestUtils.dumpAsn1Obj(token);
        }
        return null;
    }
}

