/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common;

import java.util.Arrays;
import java.util.ListIterator;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.shared.ServerReload;
import org.jboss.logging.Logger;
import org.wildfly.test.security.common.elytron.ConfigurableElement;

public abstract class AbstractElytronSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractElytronSetupTask.class);
    private ConfigurableElement[] configurableElements;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.setup(managementClient.getControllerClient());
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.tearDown(managementClient.getControllerClient());
    }

    protected void setup(ModelControllerClient modelControllerClient) throws Exception {
        this.configurableElements = this.getConfigurableElements();
        if (this.configurableElements == null || this.configurableElements.length == 0) {
            LOGGER.warn((Object)"Empty Elytron configuration.");
            return;
        }
        try (CLIWrapper cli = new CLIWrapper(true);){
            for (ConfigurableElement configurableElement : this.configurableElements) {
                LOGGER.infov("Adding element {0} ({1})", (Object)configurableElement.getName(), (Object)configurableElement.getClass().getSimpleName());
                configurableElement.create(modelControllerClient, cli);
            }
        }
        ServerReload.reloadIfRequired(modelControllerClient);
    }

    protected void tearDown(ModelControllerClient modelControllerClient) throws Exception {
        if (this.configurableElements == null || this.configurableElements.length == 0) {
            LOGGER.warn((Object)"Empty Elytron configuration.");
            return;
        }
        try (CLIWrapper cli = new CLIWrapper(true);){
            ListIterator<ConfigurableElement> reverseConfigIt = Arrays.asList(this.configurableElements).listIterator(this.configurableElements.length);
            while (reverseConfigIt.hasPrevious()) {
                ConfigurableElement configurableElement = reverseConfigIt.previous();
                LOGGER.infov("Removing element {0} ({1})", (Object)configurableElement.getName(), (Object)configurableElement.getClass().getSimpleName());
                configurableElement.remove(modelControllerClient, cli);
            }
        }
        this.configurableElements = null;
        ServerReload.reloadIfRequired(modelControllerClient);
    }

    protected abstract ConfigurableElement[] getConfigurableElements();
}

