/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.wildfly.test.security.common.elytron.Utils;

public class ElytronDomainSetup
implements ServerSetupTask {
    private static final String DEFAULT_SECURITY_DOMAIN_NAME = "elytron-tests";
    private PathAddress realmAddress;
    private PathAddress domainAddress;
    private final String usersFile;
    private final String groupsFile;
    private final String securityDomainName;

    public ElytronDomainSetup(String usersFile, String groupsFile) {
        this(usersFile, groupsFile, DEFAULT_SECURITY_DOMAIN_NAME);
    }

    public ElytronDomainSetup(String usersFile, String groupsFile, String securityDomainName) {
        this.usersFile = usersFile;
        this.groupsFile = groupsFile;
        this.securityDomainName = securityDomainName;
    }

    protected String getSecurityDomainName() {
        return this.securityDomainName;
    }

    protected String getSecurityRealmName() {
        return this.getSecurityDomainName() + "-ejb3-UsersRoles";
    }

    protected String getUndertowDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getEjbDomainName() {
        return this.getSecurityDomainName();
    }

    protected String getSaslAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getRemotingConnectorName() {
        return "http-remoting-connector";
    }

    protected String getHttpAuthenticationName() {
        return this.getSecurityDomainName();
    }

    protected String getUsersFile() {
        return this.usersFile;
    }

    protected String getGroupsFile() {
        return this.groupsFile;
    }

    protected boolean isUsersFilePlain() {
        return true;
    }

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.realmAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("properties-realm", this.getSecurityRealmName());
        this.domainAddress = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("subsystem", "elytron").append("security-domain", this.getSecurityDomainName());
        ModelNode compositeOp = new ModelNode();
        compositeOp.get("operation").set("composite");
        compositeOp.get("address").setEmptyList();
        ModelNode steps = compositeOp.get("steps");
        ModelNode addRealm = Util.createAddOperation((PathAddress)this.realmAddress);
        addRealm.get("users-properties").get("path").set(this.getUsersFile());
        addRealm.get("users-properties").get("plain-text").set(this.isUsersFilePlain());
        addRealm.get("groups-properties").get("path").set(this.getGroupsFile());
        steps.add(addRealm);
        ModelNode addDomain = Util.createAddOperation((PathAddress)this.domainAddress);
        addDomain.get("permission-mapper").set("default-permission-mapper");
        addDomain.get("default-realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("realm").set(this.getSecurityRealmName());
        addDomain.get("realms").get(0).get("role-decoder").set("groups-to-roles");
        addDomain.get("realms").get(1).get("realm").set("local");
        steps.add(addDomain);
        Utils.applyUpdate(managementClient.getControllerClient(), compositeOp, false);
    }

    public void tearDown(ManagementClient managementClient, String containerId) {
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.domainAddress, false);
        Utils.applyRemoveAllowReload(managementClient.getControllerClient(), this.realmAddress, false);
    }
}

