/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.ldap;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.NormalizingComparator;
import org.apache.directory.api.ldap.model.schema.registries.ComparatorRegistry;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schema.loader.JarLdifSchemaLoader;
import org.apache.directory.api.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.api.ldap.util.tree.DnNode;
import org.apache.directory.api.util.exception.Exceptions;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.AttributeTypeProvider;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.ObjectClassProvider;
import org.apache.directory.server.core.api.OperationEnum;
import org.apache.directory.server.core.api.OperationManager;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.administrative.AccessControlAdministrativePoint;
import org.apache.directory.server.core.api.administrative.CollectiveAttributeAdministrativePoint;
import org.apache.directory.server.core.api.administrative.SubschemaAdministrativePoint;
import org.apache.directory.server.core.api.administrative.TriggerExecutionAdministrativePoint;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.api.event.EventService;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.journal.Journal;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.api.subtree.SubentryCache;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.apache.directory.server.core.factory.AvlPartitionFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.shared.DefaultDnFactory;
import org.apache.directory.server.i18n.I18n;
import org.jboss.as.test.integration.ldap.InMemorySchemaPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static Logger LOG = LoggerFactory.getLogger(InMemoryDirectoryServiceFactory.class);
    private static volatile int counter = 1;
    private final DirectoryService directoryService;
    private final PartitionFactory partitionFactory;
    private CacheManager cacheManager;

    public InMemoryDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.directoryService.setShutdownHookEnabled(false);
        this.partitionFactory = new AvlPartitionFactory();
    }

    public InMemoryDirectoryServiceFactory(DirectoryService directoryService, PartitionFactory partitionFactory) {
        this.directoryService = directoryService;
        this.partitionFactory = partitionFactory;
    }

    public void init(String name) throws Exception {
        if (this.directoryService == null || this.directoryService.isStarted()) {
            return;
        }
        int id = counter++;
        this.directoryService.setInstanceId(name + id);
        InstanceLayout instanceLayout = new InstanceLayout(System.getProperty("java.io.tmpdir") + "/server-work-" + this.directoryService.getInstanceId());
        if (instanceLayout.getInstanceDirectory().exists()) {
            try {
                FileUtils.deleteDirectory((File)instanceLayout.getInstanceDirectory());
            }
            catch (IOException e) {
                LOG.warn("couldn't delete the instance directory before initializing the DirectoryService", (Throwable)e);
            }
        }
        this.directoryService.setInstanceLayout(instanceLayout);
        String cacheName = "ApacheDSTestCache-" + id;
        Configuration ehCacheConfig = new Configuration();
        ehCacheConfig.setName(cacheName);
        CacheConfiguration defaultCache = new CacheConfiguration(cacheName, 1).eternal(false).timeToIdleSeconds(30L).timeToLiveSeconds(30L).overflowToDisk(false);
        ehCacheConfig.addDefaultCache(defaultCache);
        this.cacheManager = new CacheManager(ehCacheConfig);
        CacheService cacheService = new CacheService(this.cacheManager);
        this.directoryService.setCacheService(cacheService);
        JarLdifSchemaLoader loader = new JarLdifSchemaLoader();
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        ComparatorRegistry comparatorRegistry = schemaManager.getComparatorRegistry();
        for (LdapComparator comparator : comparatorRegistry) {
            if (!(comparator instanceof NormalizingComparator)) continue;
            ((NormalizingComparator)comparator).setOnServer();
        }
        this.directoryService.setSchemaManager((SchemaManager)schemaManager);
        InMemorySchemaPartition inMemorySchemaPartition = new InMemorySchemaPartition((SchemaManager)schemaManager);
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)inMemorySchemaPartition);
        this.directoryService.setSchemaPartition(schemaPartition);
        List errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err((I18n)I18n.ERR_317, (Object[])new Object[]{Exceptions.printErrors((List)errors)}));
        }
        DefaultDnFactory dnFactory = new DefaultDnFactory((SchemaManager)schemaManager, cacheService.getCache("dnCache"));
        Partition systemPartition = this.partitionFactory.createPartition(this.directoryService.getSchemaManager(), (DnFactory)dnFactory, "system", "ou=system", 500, new File(this.directoryService.getInstanceLayout().getPartitionsDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.cacheManager != null ? new WrapperDirectoryService(this.directoryService, this.cacheManager) : this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }

    private class WrapperDirectoryService
    implements DirectoryService {
        private final DirectoryService wrapped;
        private final CacheManager cacheManager;

        private WrapperDirectoryService(DirectoryService wrapped, CacheManager cacheManager) {
            this.wrapped = wrapped;
            this.cacheManager = cacheManager;
        }

        public Entry newEntry(Dn dn) throws LdapException {
            return this.wrapped.newEntry(dn);
        }

        public long revert(long revision) throws LdapException {
            return this.wrapped.revert(revision);
        }

        public long revert() throws LdapException {
            return this.wrapped.revert();
        }

        public PartitionNexus getPartitionNexus() {
            return this.wrapped.getPartitionNexus();
        }

        public void addPartition(Partition partition) throws Exception {
            this.wrapped.addPartition(partition);
        }

        public void removePartition(Partition partition) throws Exception {
            this.wrapped.removePartition(partition);
        }

        public SchemaManager getSchemaManager() {
            return this.wrapped.getSchemaManager();
        }

        public LdapApiService getLdapCodecService() {
            return this.wrapped.getLdapCodecService();
        }

        public ReferralManager getReferralManager() {
            return this.wrapped.getReferralManager();
        }

        public void setReferralManager(ReferralManager referralManager) {
            this.wrapped.setReferralManager(referralManager);
        }

        public SchemaPartition getSchemaPartition() {
            return this.wrapped.getSchemaPartition();
        }

        public void setSchemaPartition(SchemaPartition schemaPartition) {
            this.wrapped.setSchemaPartition(schemaPartition);
        }

        public EventService getEventService() {
            return this.wrapped.getEventService();
        }

        public void setEventService(EventService eventService) {
            this.wrapped.setEventService(eventService);
        }

        public void startup() throws Exception {
            this.wrapped.startup();
        }

        public void shutdown() throws Exception {
            this.wrapped.shutdown();
            this.cacheManager.shutdown();
        }

        public void sync() throws Exception {
            this.wrapped.sync();
        }

        public boolean isStarted() {
            return this.wrapped.isStarted();
        }

        public CoreSession getAdminSession() {
            return this.wrapped.getAdminSession();
        }

        public SubentryCache getSubentryCache() {
            return this.wrapped.getSubentryCache();
        }

        public SubtreeEvaluator getEvaluator() {
            return this.wrapped.getEvaluator();
        }

        public CoreSession getSession() throws Exception {
            return this.wrapped.getSession();
        }

        public CoreSession getSession(LdapPrincipal principal) throws Exception {
            return this.wrapped.getSession(principal);
        }

        public CoreSession getSession(Dn principalDn, byte[] credentials) throws LdapException {
            return this.wrapped.getSession(principalDn, credentials);
        }

        public CoreSession getSession(Dn principalDn, byte[] credentials, String saslMechanism, String saslAuthId) throws Exception {
            return this.wrapped.getSession(principalDn, credentials, saslMechanism, saslAuthId);
        }

        public void setInstanceId(String instanceId) {
            this.wrapped.setInstanceId(instanceId);
        }

        public String getInstanceId() {
            return this.wrapped.getInstanceId();
        }

        public Set<? extends Partition> getPartitions() {
            return this.wrapped.getPartitions();
        }

        public void setPartitions(Set<? extends Partition> partitions) {
            this.wrapped.setPartitions(partitions);
        }

        public boolean isAccessControlEnabled() {
            return this.wrapped.isAccessControlEnabled();
        }

        public void setAccessControlEnabled(boolean accessControlEnabled) {
            this.wrapped.setAccessControlEnabled(accessControlEnabled);
        }

        public boolean isAllowAnonymousAccess() {
            return this.wrapped.isAllowAnonymousAccess();
        }

        public boolean isPasswordHidden() {
            return this.wrapped.isPasswordHidden();
        }

        public void setPasswordHidden(boolean passwordHidden) {
            this.wrapped.setPasswordHidden(passwordHidden);
        }

        public void setAllowAnonymousAccess(boolean enableAnonymousAccess) {
            this.wrapped.setAllowAnonymousAccess(enableAnonymousAccess);
        }

        public List<Interceptor> getInterceptors() {
            return this.wrapped.getInterceptors();
        }

        public List<String> getInterceptors(OperationEnum operation) {
            return this.wrapped.getInterceptors(operation);
        }

        public void setInterceptors(List<Interceptor> interceptors) {
            this.wrapped.setInterceptors(interceptors);
        }

        public void addFirst(Interceptor interceptor) throws LdapException {
            this.wrapped.addFirst(interceptor);
        }

        public void addLast(Interceptor interceptor) throws LdapException {
            this.wrapped.addLast(interceptor);
        }

        public void addAfter(String interceptorName, Interceptor interceptor) {
            this.wrapped.addAfter(interceptorName, interceptor);
        }

        public void remove(String interceptorName) {
            this.wrapped.remove(interceptorName);
        }

        public void setJournal(Journal journal) {
            this.wrapped.setJournal(journal);
        }

        public List<LdifEntry> getTestEntries() {
            return this.wrapped.getTestEntries();
        }

        public void setTestEntries(List<? extends LdifEntry> testEntries) {
            this.wrapped.setTestEntries(testEntries);
        }

        public InstanceLayout getInstanceLayout() {
            return this.wrapped.getInstanceLayout();
        }

        public void setInstanceLayout(InstanceLayout instanceLayout) throws IOException {
            this.wrapped.setInstanceLayout(instanceLayout);
        }

        public void setShutdownHookEnabled(boolean shutdownHookEnabled) {
            this.wrapped.setShutdownHookEnabled(shutdownHookEnabled);
        }

        public boolean isShutdownHookEnabled() {
            return this.wrapped.isShutdownHookEnabled();
        }

        public void setExitVmOnShutdown(boolean exitVmOnShutdown) {
            this.wrapped.setExitVmOnShutdown(exitVmOnShutdown);
        }

        public boolean isExitVmOnShutdown() {
            return this.wrapped.isExitVmOnShutdown();
        }

        public void setSystemPartition(Partition systemPartition) {
            this.wrapped.setSystemPartition(systemPartition);
        }

        public Partition getSystemPartition() {
            return this.wrapped.getSystemPartition();
        }

        public boolean isDenormalizeOpAttrsEnabled() {
            return this.wrapped.isDenormalizeOpAttrsEnabled();
        }

        public void setDenormalizeOpAttrsEnabled(boolean denormalizeOpAttrsEnabled) {
            this.wrapped.setDenormalizeOpAttrsEnabled(denormalizeOpAttrsEnabled);
        }

        public ChangeLog getChangeLog() {
            return this.wrapped.getChangeLog();
        }

        public Journal getJournal() {
            return this.wrapped.getJournal();
        }

        public void setChangeLog(ChangeLog changeLog) {
            this.wrapped.setChangeLog(changeLog);
        }

        public Entry newEntry(String ldif, String dn) {
            return this.wrapped.newEntry(ldif, dn);
        }

        public OperationManager getOperationManager() {
            return this.wrapped.getOperationManager();
        }

        public int getMaxPDUSize() {
            return this.wrapped.getMaxPDUSize();
        }

        public void setMaxPDUSize(int maxPDUSize) {
            this.wrapped.setMaxPDUSize(maxPDUSize);
        }

        public Interceptor getInterceptor(String interceptorName) {
            return this.wrapped.getInterceptor(interceptorName);
        }

        public Csn getCSN() {
            return this.wrapped.getCSN();
        }

        public int getReplicaId() {
            return this.wrapped.getReplicaId();
        }

        public void setReplicaId(int replicaId) {
            this.wrapped.setReplicaId(replicaId);
        }

        public void setSchemaManager(SchemaManager schemaManager) {
            this.wrapped.setSchemaManager(schemaManager);
        }

        public void setSyncPeriodMillis(long syncPeriodMillis) {
            this.wrapped.setSyncPeriodMillis(syncPeriodMillis);
        }

        public long getSyncPeriodMillis() {
            return this.wrapped.getSyncPeriodMillis();
        }

        public CacheService getCacheService() {
            return this.wrapped.getCacheService();
        }

        public DnNode<AccessControlAdministrativePoint> getAccessControlAPCache() {
            return this.wrapped.getAccessControlAPCache();
        }

        public DnNode<CollectiveAttributeAdministrativePoint> getCollectiveAttributeAPCache() {
            return this.wrapped.getCollectiveAttributeAPCache();
        }

        public DnNode<SubschemaAdministrativePoint> getSubschemaAPCache() {
            return this.wrapped.getSubschemaAPCache();
        }

        public DnNode<TriggerExecutionAdministrativePoint> getTriggerExecutionAPCache() {
            return this.wrapped.getTriggerExecutionAPCache();
        }

        public boolean isPwdPolicyEnabled() {
            return this.wrapped.isPwdPolicyEnabled();
        }

        public DnFactory getDnFactory() {
            return this.wrapped.getDnFactory();
        }

        public void setCacheService(CacheService cacheService) {
            this.wrapped.setCacheService(cacheService);
        }

        public AttributeTypeProvider getAtProvider() {
            return this.wrapped.getAtProvider();
        }

        public ObjectClassProvider getOcProvider() {
            return this.wrapped.getOcProvider();
        }

        public void setDnFactory(DnFactory dnFactory) {
            this.wrapped.setDnFactory(dnFactory);
        }
    }
}

