/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;

public class UndertowSslContext
extends AbstractConfigurableElement {
    private String httpsListener;

    private UndertowSslContext(Builder builder) {
        super(builder);
        this.httpsListener = builder.httpsListener;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        cli.sendLine("batch");
        cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:undefine-attribute(name=security-realm)", this.httpsListener));
        cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:write-attribute(name=ssl-context,value=%s)", this.httpsListener, this.name));
        cli.sendLine("run-batch");
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine("batch");
        cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:undefine-attribute(name=ssl-context)", this.httpsListener));
        cli.sendLine(String.format("/subsystem=undertow/server=default-server/https-listener=%s:write-attribute(name=security-realm,value=ApplicationRealm)", this.httpsListener));
        cli.sendLine("run-batch");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractConfigurableElement.Builder<Builder> {
        private String httpsListener = "https";

        private Builder() {
        }

        public Builder withHttpsListener(String httpsListener) {
            this.httpsListener = httpsListener;
            return this;
        }

        public UndertowSslContext build() {
            return new UndertowSslContext(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

