/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.shared.CliUtils;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.test.security.common.elytron.AbstractUserRolesCapableElement;
import org.wildfly.test.security.common.elytron.SecurityDomain;
import org.wildfly.test.security.common.elytron.UserWithRoles;

public class PropertyFileAuthzBasedDomain
extends AbstractUserRolesCapableElement
implements SecurityDomain {
    private static final Logger LOGGER = Logger.getLogger(PropertyFileAuthzBasedDomain.class);
    private final String principalDecoder;
    private final String authnRealm;
    private final String authzRealm;
    private final String aggregateRealm;
    private File tempFolder;

    private PropertyFileAuthzBasedDomain(Builder builder) {
        super(builder);
        this.principalDecoder = builder.principalDecoder;
        this.authnRealm = Objects.requireNonNull(builder.authnRealm, "Realm for authentication must not be null");
        this.authzRealm = this.name + "-authzRealm";
        this.aggregateRealm = this.name + "-aggregateRealm";
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        this.tempFolder = PropertyFileAuthzBasedDomain.createTemporaryFolder("ely-" + this.getName());
        Properties usersProperties = new Properties();
        Properties rolesProperties = new Properties();
        for (UserWithRoles user : this.getUsersWithRoles()) {
            usersProperties.setProperty(user.getName(), user.getPassword());
            rolesProperties.setProperty(user.getName(), String.join((CharSequence)",", user.getRoles()));
        }
        File usersFile = this.writeProperties(usersProperties, "users.properties");
        File rolesFile = this.writeProperties(rolesProperties, "roles.properties");
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:add(users-properties={path=\"%s\", plain-text=true}, groups-properties={path=\"%s\"})", this.authzRealm, CliUtils.asAbsolutePath(usersFile), CliUtils.asAbsolutePath(rolesFile)));
        cli.sendLine(String.format("/subsystem=elytron/aggregate-realm=%s:add(authentication-realm=%s,authorization-realm=%s)", this.aggregateRealm, this.authnRealm, this.authzRealm));
        cli.sendLine(String.format("/subsystem=elytron/simple-role-decoder=%s:add(attribute=groups)", this.name));
        cli.sendLine(String.format("/subsystem=elytron/constant-permission-mapper=%s:add(permissions=[{class-name=\"%s\"}])", this.name, LoginPermission.class.getName()));
        StringBuilder command = new StringBuilder("/subsystem=elytron/security-domain=").append(this.name).append(":add(default-realm=").append(this.aggregateRealm).append(",permission-mapper=").append(this.name).append(",realms=[{role-decoder=").append(this.name).append(",realm=").append(this.aggregateRealm).append("}]");
        if (this.principalDecoder != null) {
            command.append(",principal-decoder=").append(this.principalDecoder);
        }
        command.append(")");
        cli.sendLine(String.format(command.toString(), new Object[0]));
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/security-domain=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/constant-permission-mapper=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/simple-role-decoder=%s:remove()", this.name));
        cli.sendLine(String.format("/subsystem=elytron/aggregate-realm=%s:remove()", this.aggregateRealm));
        cli.sendLine(String.format("/subsystem=elytron/properties-realm=%s:remove()", this.authzRealm));
        FileUtils.deleteQuietly((File)this.tempFolder);
    }

    public static Builder builder() {
        return new Builder();
    }

    private File writeProperties(Properties properties, String fileName) throws IOException {
        File result = new File(this.tempFolder, fileName);
        LOGGER.debugv("Creating property file {0}", (Object)result);
        try (FileOutputStream fos = new FileOutputStream(result);){
            properties.store(fos, "$REALM_NAME=" + this.name + "$");
        }
        return result;
    }

    private static File createTemporaryFolder(String prefix) throws IOException {
        File file = File.createTempFile(prefix, "", null);
        LOGGER.debugv("Creating temporary folder {0}", (Object)file);
        file.delete();
        file.mkdir();
        return file;
    }

    public static final class Builder
    extends AbstractUserRolesCapableElement.Builder<Builder> {
        private String authnRealm;
        private String principalDecoder;

        private Builder() {
        }

        public Builder withAuthnRealm(String authnRealm) {
            this.authnRealm = authnRealm;
            return this;
        }

        public Builder withPrincipalDecoder(String principalDecoder) {
            this.principalDecoder = principalDecoder;
            return this;
        }

        public PropertyFileAuthzBasedDomain build() {
            return new PropertyFileAuthzBasedDomain(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

