/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.as.test.integration.common.HttpRequest;

@WebServlet(urlPatterns={"/JndiServlet"})
public class JndiServlet
extends HttpServlet {
    public static final String NOT_FOUND = "NOT_FOUND";

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NamingException {
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        String name = request.getParameter("name");
        if (name == null) {
            throw new ServletException("Lookup name not specified.");
        }
        InitialContext ctx = new InitialContext();
        Object obj = null;
        try {
            obj = ctx.lookup(name);
            out.print(obj.getClass().getName());
        }
        catch (NameNotFoundException nnfe) {
            out.print(NOT_FOUND);
        }
        out.close();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (NamingException ne) {
            throw new ServletException((Throwable)ne);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processRequest(request, response);
        }
        catch (NamingException ne) {
            throw new ServletException((Throwable)ne);
        }
    }

    public static String lookup(String URL2, String name) throws IOException {
        try {
            return HttpRequest.get((String)(URL2 + "/JndiServlet?name=" + URLEncoder.encode(name, "UTF-8")), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException ex) {
            return null;
        }
        catch (TimeoutException ex) {
            return null;
        }
    }
}

