/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.AbstractServerLoginModule;

public class AddRoleLoginModule
extends AbstractServerLoginModule {
    private static final String ROLE_NAME = "roleName";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"roleName"};
    private String role;
    private Principal identity;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, callbackHandler, sharedState, options);
        this.role = (String)options.get(ROLE_NAME);
    }

    public boolean login() throws LoginException {
        if (super.login()) {
            Object username = this.sharedState.get("javax.security.auth.login.name");
            if (username instanceof Principal) {
                this.identity = (Principal)username;
            } else {
                String name = username.toString();
                try {
                    this.identity = this.createIdentity(name);
                }
                catch (Exception e) {
                    LoginException le = new LoginException("Identity creation failed");
                    le.initCause(e);
                    throw new LoginException("Identity");
                }
            }
            return true;
        }
        return false;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        roles.addMember((Principal)new SimplePrincipal(this.role));
        return new Group[]{roles};
    }

    protected Principal getIdentity() {
        return this.identity;
    }
}

