/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.util;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;

public class LoggingUtil {
    public static Path getLogPath(ManagementClient managementClient, String handlerType, String name) throws Exception {
        ModelNode address = Operations.createAddress((String[])new String[]{"subsystem", "logging", handlerType, name});
        ModelNode op = Operations.createOperation((String)"resolve-path", (ModelNode)address);
        ModelNode result = managementClient.getControllerClient().execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new Exception("Can't get log file");
        }
        return Paths.get(Operations.readResult((ModelNode)result).asString(), new String[0]);
    }

    public static Path getInServerLogPath(String logFile) {
        return Paths.get(System.getProperty("jboss.server.log.dir"), new String[0]).resolve(logFile);
    }

    public static boolean hasLogMessage(String logFileName, String logMessage) throws Exception {
        boolean found = false;
        Path logPath = LoggingUtil.getInServerLogPath(logFileName);
        try (BufferedReader fileReader = Files.newBufferedReader(logPath);){
            String line = "";
            while ((line = fileReader.readLine()) != null) {
                if (!line.contains(logMessage)) continue;
                found = true;
                break;
            }
        }
        return found;
    }
}

