/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.wildfly.test.security.common.elytron.AbstractConfigurableElement;
import org.wildfly.test.security.common.elytron.UserWithAttributeValues;
import org.wildfly.test.security.common.elytron.UsersAttributeValuesCapableElement;

public abstract class AbstractUserAttributeValuesCapableElement
extends AbstractConfigurableElement
implements UsersAttributeValuesCapableElement {
    private final List<UserWithAttributeValues> usersWithValues;

    protected AbstractUserAttributeValuesCapableElement(Builder<?> builder) {
        super(builder);
        this.usersWithValues = Collections.unmodifiableList(new ArrayList(((Builder)builder).usersWithValues));
    }

    @Override
    public List<UserWithAttributeValues> getUsersWithAttributeValues() {
        return this.usersWithValues;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends AbstractConfigurableElement.Builder<T> {
        private List<UserWithAttributeValues> usersWithValues = new ArrayList<UserWithAttributeValues>();

        protected Builder() {
        }

        public final T withUser(UserWithAttributeValues userWithValues) {
            this.usersWithValues.add(Objects.requireNonNull(userWithValues, "Provided user must not be null."));
            return (T)((Builder)this.self());
        }

        public final T withUser(String username, String password, String ... values) {
            this.usersWithValues.add(UserWithAttributeValues.builder().withName(username).withPassword(password).withValues(values).build());
            return (T)((Builder)this.self());
        }
    }
}

