/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.logging.Logger;

@WebServlet(value={"/PrintAttrServlet"})
public class PrintAttributeServlet
extends HttpServlet {
    private static Logger LOGGER = Logger.getLogger(PrintAttributeServlet.class);
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/PrintAttrServlet";
    public static final String PARAM_ATTR_NAME = "attr";
    public static final String PARAM_SCOPE_NAME = "scope";
    public static final String DELIMITER = "/";
    public static final String DEFAULT_PROPERTY_NAME = "SESSION_ATTRIBUTE_MAP/cn/0";
    public static final String SCOPE_REQUEST = "request";
    public static final String SCOPE_SESSION = "session";
    public static final String DEFAULT_SCOPE_NAME = "session";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        String attrName = req.getParameter(PARAM_ATTR_NAME);
        if (attrName == null || attrName.length() == 0) {
            attrName = DEFAULT_PROPERTY_NAME;
        }
        StringTokenizer st = new StringTokenizer(attrName, DELIMITER);
        String actualName = st.nextToken();
        Object actualValue = null;
        if (SCOPE_REQUEST.equalsIgnoreCase(req.getParameter(PARAM_SCOPE_NAME))) {
            actualValue = req.getAttribute(actualName);
        } else {
            HttpSession session = req.getSession(false);
            if (session != null) {
                actualValue = session.getAttribute(actualName);
            }
        }
        while (st.hasMoreTokens() && (actualValue instanceof Map || actualValue instanceof List)) {
            actualName = st.nextToken();
            if (actualValue instanceof List) {
                try {
                    actualValue = ((List)actualValue).get(Integer.parseInt(actualName));
                }
                catch (Exception e) {
                    LOGGER.warn((Object)"Unable to retrieve value from list", (Throwable)e);
                    actualValue = null;
                }
                continue;
            }
            actualValue = ((Map)actualValue).get(actualName);
        }
        PrintWriter writer = resp.getWriter();
        writer.write(String.valueOf(actualValue));
        writer.close();
    }
}

