/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.test.security.common.elytron;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.as.test.integration.management.util.CLIWrapper;
import org.jboss.as.test.integration.security.common.Utils;
import org.wildfly.test.security.common.elytron.AbstractUserAttributeValuesCapableElement;
import org.wildfly.test.security.common.elytron.Path;
import org.wildfly.test.security.common.elytron.SecurityRealm;
import org.wildfly.test.security.common.elytron.UserWithAttributeValues;

public class FileSystemRealm
extends AbstractUserAttributeValuesCapableElement
implements SecurityRealm {
    private final Path path;
    private final Integer level;
    private final File tempFolder;

    private FileSystemRealm(Builder builder) {
        super(builder);
        if (builder.path != null) {
            this.tempFolder = null;
            this.path = builder.path;
        } else {
            try {
                this.tempFolder = Utils.createTemporaryFolder("ely-" + this.getName());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary folder", e);
            }
            this.path = Path.builder().withPath(this.tempFolder.getAbsolutePath()).build();
        }
        this.level = builder.level;
    }

    @Override
    public void create(CLIWrapper cli) throws Exception {
        String levelStr = this.level == null ? "" : "level=" + this.level;
        cli.sendLine(String.format("/subsystem=elytron/filesystem-realm=%s:add(%s, %s)", this.name, this.path.asString(), levelStr));
        for (UserWithAttributeValues user : this.getUsersWithAttributeValues()) {
            cli.sendLine(String.format("/subsystem=elytron/filesystem-realm=%s:add-identity(identity=%s)", this.name, user.getName()));
            cli.sendLine(String.format("/subsystem=elytron/filesystem-realm=%s:set-password(identity=%s, clear={password=\"%s\"})", this.name, user.getName(), user.getPassword()));
            if (user.getValues().isEmpty()) continue;
            cli.sendLine(String.format("/subsystem=elytron/filesystem-realm=%s:add-identity-attribute(identity=%s, name=groups, value=[%s])", this.name, user.getName(), String.join((CharSequence)",", user.getValues())));
        }
    }

    @Override
    public void remove(CLIWrapper cli) throws Exception {
        cli.sendLine(String.format("/subsystem=elytron/filesystem-realm=%s:remove()", this.name));
        FileUtils.deleteQuietly((File)this.tempFolder);
    }

    public Path getPath() {
        return this.path;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractUserAttributeValuesCapableElement.Builder<Builder> {
        private Path path;
        private Integer level;

        private Builder() {
        }

        public Builder withPath(Path path) {
            this.path = path;
            return this;
        }

        public Builder withLevel(Integer level) {
            this.level = level;
            return this;
        }

        public FileSystemRealm build() {
            return new FileSystemRealm(this);
        }

        @Override
        public Builder self() {
            return this;
        }
    }
}

