/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.transactions;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.as.test.integration.transactions.TransactionCheckerSingleton;
import org.jboss.logging.Logger;

public class TestXAResource
implements XAResource {
    private static Logger log = Logger.getLogger(TestXAResource.class);
    private static final List<Xid> preparedXids = new ArrayList<Xid>();
    private TransactionCheckerSingleton checker;
    private int transactionTimeout;
    protected TestAction testAction;

    public TestXAResource(TransactionCheckerSingleton checker) {
        this(TestAction.NONE, checker);
    }

    public TestXAResource() {
        this(TestAction.NONE);
    }

    public TestXAResource(TestAction testAction) {
        this(testAction, new TransactionCheckerSingleton());
    }

    public TestXAResource(TestAction testAction, TransactionCheckerSingleton checker) {
        log.debugf("created %s with testAction %s and checker %s", (Object)this.getClass().getName(), (Object)testAction, (Object)checker);
        this.checker = checker;
        this.testAction = testAction;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        log.debugf("prepare xid: [%s], test action: %s", (Object)xid, (Object)this.testAction);
        this.checker.addPrepare();
        switch (this.testAction) {
            case PREPARE_THROW_XAER_RMERR: {
                throw new XAException(-3);
            }
            case PREPARE_THROW_XAER_RMFAIL: {
                throw new XAException(-7);
            }
            case PREPARE_THROW_UNKNOWN_XA_EXCEPTION: {
                throw new XAException(null);
            }
            case PREPARE_CRASH_VM: {
                Runtime.getRuntime().halt(0);
            }
        }
        preparedXids.add(xid);
        return 0;
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        log.debugf("commit xid:[%s], %s one phase, test action: %s", (Object)xid, (Object)(onePhase ? "with" : "without"), (Object)this.testAction);
        this.checker.addCommit();
        switch (this.testAction) {
            case COMMIT_THROW_XAER_RMERR: {
                throw new XAException(-3);
            }
            case COMMIT_THROW_XAER_RMFAIL: {
                throw new XAException(-7);
            }
            case COMMIT_THROW_UNKNOWN_XA_EXCEPTION: {
                throw new XAException(null);
            }
            case COMMIT_CRASH_VM: {
                Runtime.getRuntime().halt(0);
            }
        }
        preparedXids.remove(xid);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        log.debugf("rollback xid: [%s]", (Object)xid);
        this.checker.addRollback();
        preparedXids.remove(xid);
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        log.debugf("end xid:[%s], flag: %s", (Object)xid, (Object)flags);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.debugf("forget xid:[%s]", (Object)xid);
        preparedXids.remove(xid);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        log.debugf("getTransactionTimeout: returning timeout: %s", this.transactionTimeout);
        return this.transactionTimeout;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        log.debugf("isSameRM returning false to xares: %s", (Object)xares);
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        log.debugf("recover with flags: %s", flag);
        return preparedXids.toArray(new Xid[0]);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        log.debugf("setTransactionTimeout: setting timeout: %s", seconds);
        this.transactionTimeout = seconds;
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        log.debugf("start xid: [%s], flags: %s", (Object)xid, (Object)flags);
    }

    public List<Xid> getPreparedXids() {
        return preparedXids;
    }

    public static enum TestAction {
        NONE,
        PREPARE_THROW_XAER_RMERR,
        PREPARE_THROW_XAER_RMFAIL,
        PREPARE_THROW_UNKNOWN_XA_EXCEPTION,
        PREPARE_CRASH_VM,
        COMMIT_THROW_XAER_RMERR,
        COMMIT_THROW_XAER_RMFAIL,
        COMMIT_THROW_UNKNOWN_XA_EXCEPTION,
        COMMIT_CRASH_VM;

    }
}

