/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared.integration.ejb.security;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.Arrays;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public final class PermissionUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Asset createPermissionsXmlAsset(Permission ... permissions) {
        Element permissionsElement = new Element("permissions");
        permissionsElement.setNamespaceURI("http://xmlns.jcp.org/xml/ns/javaee");
        permissionsElement.addAttribute(new Attribute("version", "7"));
        for (Permission permission : permissions) {
            Element permissionElement = new Element("permission");
            Element classNameElement = new Element("class-name");
            Element nameElement = new Element("name");
            classNameElement.appendChild(permission.getClass().getName());
            nameElement.appendChild(permission.getName());
            permissionElement.appendChild((Node)classNameElement);
            permissionElement.appendChild((Node)nameElement);
            String actions = permission.getActions();
            if (actions != null && !actions.isEmpty()) {
                Element actionsElement = new Element("actions");
                actionsElement.appendChild(actions);
                permissionElement.appendChild((Node)actionsElement);
            }
            permissionsElement.appendChild((Node)permissionElement);
        }
        Document document = new Document(permissionsElement);
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            NiceSerializer serializer = new NiceSerializer(stream);
            serializer.setIndent(4);
            serializer.setLineSeparator("\n");
            serializer.write(document);
            serializer.flush();
            StringAsset stringAsset = new StringAsset(stream.toString("UTF-8"));
            return stringAsset;
        }
        catch (IOException e) {
            throw new IllegalStateException("Generating permissions.xml failed", e);
        }
    }

    public static FilePermission createFilePermission(String action, String ... paths) {
        return PermissionUtils.createFilePermission(action, "jboss.inst", Arrays.asList(paths));
    }

    public static FilePermission createFilePermission(String action, String sysPropKey, Iterable<String> paths) {
        String prop = System.getProperty(sysPropKey);
        if (prop == null) {
            throw new IllegalArgumentException(String.format("Could not find the system property %s", sysPropKey));
        }
        Path base = Paths.get(prop, new String[0]);
        if (Files.notExists(base, new LinkOption[0])) {
            throw new RuntimeException(String.format("The system property %s resolved to %s which does not exist.", sysPropKey, base));
        }
        if (!Files.isDirectory(base, new LinkOption[0])) {
            throw new RuntimeException(String.format("The system property %s resolved to %s which is not a directory.", sysPropKey, base));
        }
        StringBuilder path = new StringBuilder(256).append(base.toAbsolutePath().normalize()).append(File.separatorChar);
        Iterator<String> iter = paths.iterator();
        while (iter.hasNext()) {
            path.append(iter.next());
            if (!iter.hasNext()) continue;
            path.append(File.separatorChar);
        }
        return new FilePermission(path.toString(), action);
    }

    static class NiceSerializer
    extends Serializer {
        public NiceSerializer(OutputStream out) throws UnsupportedEncodingException {
            super(out, "UTF-8");
        }

        protected void writeXMLDeclaration() throws IOException {
            super.writeXMLDeclaration();
            super.breakLine();
        }
    }
}

